/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.ParametricType;
import com.google.common.base.Preconditions;
import java.util.List;

public final class MapParametricType
implements ParametricType {
    public static final MapParametricType MAP = new MapParametricType();

    private MapParametricType() {
    }

    @Override
    public String getName() {
        return "map";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Expected two parameters, got %s", (Object[])new Object[]{parameters});
        TypeParameter firstParameter = parameters.get(0);
        TypeParameter secondParameter = parameters.get(1);
        Preconditions.checkArgument((firstParameter.getKind() == ParameterKind.TYPE && secondParameter.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected key and type to be types, got %s", (Object[])new Object[]{parameters});
        return new MapType(firstParameter.getType(), secondParameter.getType());
    }
}

