/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.ParametricType;
import com.google.common.base.Preconditions;
import java.util.List;

public final class ArrayParametricType
implements ParametricType {
    public static final ArrayParametricType ARRAY = new ArrayParametricType();

    private ArrayParametricType() {
    }

    @Override
    public String getName() {
        return "array";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Array type expects exactly one type as a parameter, got %s", (Object[])new Object[]{parameters});
        Preconditions.checkArgument((parameters.get(0).getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Array expects type as a parameter, got %s", (Object[])new Object[]{parameters});
        return new ArrayType(parameters.get(0).getType());
    }
}

