/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.UUID;

public class LegacyTransactionHandle
implements ConnectorTransactionHandle {
    private final String connectorId;
    private final UUID uuid;

    @JsonCreator
    public LegacyTransactionHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="uuid") UUID uuid) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.uuid = Objects.requireNonNull(uuid, "uuid is null");
    }

    public static LegacyTransactionHandle create(String connectorId) {
        return new LegacyTransactionHandle(connectorId, UUID.randomUUID());
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public UUID getUuid() {
        return this.uuid;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.uuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LegacyTransactionHandle other = (LegacyTransactionHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.uuid, other.uuid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("uuid", (Object)this.uuid).toString();
    }
}

