/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.Session;
import com.facebook.presto.TaskSource;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.CatalogSystemTable;
import com.facebook.presto.connector.system.GlobalSystemConnectorFactory;
import com.facebook.presto.connector.system.NodeSystemTable;
import com.facebook.presto.connector.system.TablePropertiesSystemTable;
import com.facebook.presto.connector.system.TransactionsSystemTable;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PageSourceOperator;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.planner.PlanPrinter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.testing.TreeAssertions;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializingOperator;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public class LocalQueryRunner
implements QueryRunner {
    private final Session defaultSession;
    private final ExecutorService executor;
    private final ScheduledExecutorService transactionCheckExecutor;
    private final FinalizerService finalizerService;
    private final SqlParser sqlParser;
    private final InMemoryNodeManager nodeManager;
    private final TypeRegistry typeRegistry;
    private final MetadataManager metadata;
    private final TestingAccessControlManager accessControl;
    private final SplitManager splitManager;
    private final BlockEncodingSerde blockEncodingSerde;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final TransactionManager transactionManager;
    private final ExpressionCompiler compiler;
    private final ConnectorManager connectorManager;
    private final ImmutableMap<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;
    private boolean printPlan;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LocalQueryRunner(Session defaultSession) {
        this(defaultSession, false);
    }

    private LocalQueryRunner(Session defaultSession, boolean withInitialTransaction) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() || !withInitialTransaction ? 1 : 0) != 0, (Object)"Already in transaction");
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"local-query-runner-%s"));
        this.transactionCheckExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.sqlParser = new SqlParser();
        this.nodeManager = new InMemoryNodeManager();
        this.typeRegistry = new TypeRegistry();
        this.indexManager = new IndexManager();
        NodeScheduler nodeScheduler = new NodeScheduler(new LegacyNetworkTopology(), this.nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(this.finalizerService));
        this.pageSinkManager = new PageSinkManager();
        this.transactionManager = TransactionManager.create(new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.DAYS)), this.transactionCheckExecutor, this.executor);
        this.nodePartitioningManager = new NodePartitioningManager(nodeScheduler);
        this.splitManager = new SplitManager();
        this.blockEncodingSerde = new BlockEncodingManager((TypeManager)this.typeRegistry, new BlockEncodingFactory[0]);
        this.metadata = new MetadataManager(new FeaturesConfig().setExperimentalSyntaxEnabled(true), this.typeRegistry, this.blockEncodingSerde, new SessionPropertyManager(), new TablePropertyManager(), this.transactionManager);
        this.accessControl = new TestingAccessControlManager(this.transactionManager);
        this.pageSourceManager = new PageSourceManager();
        this.compiler = new ExpressionCompiler(this.metadata);
        this.connectorManager = new ConnectorManager(this.metadata, this.accessControl, this.splitManager, this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, new HandleResolver(), this.nodeManager, this.transactionManager);
        GlobalSystemConnectorFactory globalSystemConnectorFactory = new GlobalSystemConnectorFactory((Set<SystemTable>)ImmutableSet.of((Object)new NodeSystemTable(this.nodeManager), (Object)new CatalogSystemTable(this.metadata), (Object)new TablePropertiesSystemTable(this.metadata), (Object)new TransactionsSystemTable(this.typeRegistry, this.transactionManager)), (Set<Procedure>)ImmutableSet.of());
        this.connectorManager.addConnectorFactory(globalSystemConnectorFactory);
        this.connectorManager.createConnection("system", "system", (Map<String, String>)ImmutableMap.of());
        this.defaultSession = new Session(defaultSession.getQueryId(), withInitialTransaction ? Optional.of(this.transactionManager.beginTransaction(false)) : defaultSession.getTransactionId(), defaultSession.isClientTransactionSupport(), defaultSession.getIdentity(), defaultSession.getSource(), defaultSession.getCatalog(), defaultSession.getSchema(), defaultSession.getTimeZoneKey(), defaultSession.getLocale(), defaultSession.getRemoteUserAddress(), defaultSession.getUserAgent(), defaultSession.getStartTime(), defaultSession.getSystemProperties(), defaultSession.getCatalogProperties(), this.metadata.getSessionPropertyManager());
        this.dataDefinitionTask = ImmutableMap.builder().put(CreateTable.class, (Object)new CreateTableTask()).put(CreateView.class, (Object)new CreateViewTask((JsonCodec<ViewDefinition>)JsonCodec.jsonCodec(ViewDefinition.class), this.sqlParser, this.accessControl, new FeaturesConfig())).put(DropTable.class, (Object)new DropTableTask()).put(DropView.class, (Object)new DropViewTask()).put(RenameColumn.class, (Object)new RenameColumnTask()).put(RenameTable.class, (Object)new RenameTableTask()).put(ResetSession.class, (Object)new ResetSessionTask()).put(SetSession.class, (Object)new SetSessionTask()).put(StartTransaction.class, (Object)new StartTransactionTask()).put(Commit.class, (Object)new CommitTask()).put(Rollback.class, (Object)new RollbackTask()).build();
    }

    public static LocalQueryRunner queryRunnerWithInitialTransaction(Session defaultSession) {
        Preconditions.checkArgument((!defaultSession.getTransactionId().isPresent() ? 1 : 0) != 0, (Object)"Already in transaction!");
        return new LocalQueryRunner(defaultSession, true);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        this.transactionCheckExecutor.shutdownNow();
        this.connectorManager.stop();
        this.finalizerService.destroy();
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    public InMemoryNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public TypeRegistry getTypeManager() {
        return this.typeRegistry;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public TestingAccessControlManager getAccessControl() {
        return this.accessControl;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public Session getDefaultSession() {
        return this.defaultSession;
    }

    public void createCatalog(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeDatasource(catalogName);
        this.connectorManager.addConnectorFactory(connectorFactory);
        this.connectorManager.createConnection(catalogName, connectorFactory.getName(), properties);
    }

    @Deprecated
    public void createCatalog(String catalogName, com.facebook.presto.spi.ConnectorFactory connectorFactory, Map<String, String> properties) {
        this.nodeManager.addCurrentNodeDatasource(catalogName);
        this.connectorManager.addConnectorFactory(connectorFactory);
        this.connectorManager.createConnection(catalogName, connectorFactory.getName(), properties);
    }

    @Override
    public void installPlugin(Plugin plugin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public LocalQueryRunner printPlan() {
        this.printPlan = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List list = TransactionBuilder.transaction(this.transactionManager).readOnly().execute(session, (Session transactionSession) -> this.getMetadata().listTables((Session)transactionSession, new QualifiedTablePrefix(catalog, schema)));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = TransactionBuilder.transaction(this.transactionManager).readOnly().execute(session, (Session transactionSession) -> MetadataUtil.tableExists(this.getMetadata(), transactionSession, table));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public MaterializedResult execute(@Language(value="SQL") String sql) {
        return this.execute(this.defaultSession, sql);
    }

    @Override
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        return TransactionBuilder.transaction(this.transactionManager).singleStatement().execute(session, (Session transactionSession) -> this.executeInternal((Session)transactionSession, sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaterializedResult executeInternal(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedOutputFactory outputFactory = new MaterializedOutputFactory();
            TaskContext taskContext = TestingTaskContext.createTaskContext(this.executor, session);
            List<Driver> drivers = this.createDrivers(session, sql, outputFactory, taskContext);
            boolean done = false;
            while (!done) {
                boolean processed = false;
                for (Driver driver : drivers) {
                    if (driver.isFinished()) continue;
                    driver.process();
                    processed = true;
                }
                done = !processed;
            }
            MaterializedResult materializedResult = outputFactory.getMaterializedResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    public List<Driver> createDrivers(@Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        return this.createDrivers(this.defaultSession, sql, outputFactory, taskContext);
    }

    public List<Driver> createDrivers(Session session, @Language(value="SQL") String sql, OutputFactory outputFactory, TaskContext taskContext) {
        SubPlan subplan;
        Statement statement = this.sqlParser.createStatement(sql);
        TreeAssertions.assertFormattedSql((SqlParser)this.sqlParser, (Node)statement);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        FeaturesConfig featuresConfig = new FeaturesConfig().setExperimentalSyntaxEnabled(true).setDistributedIndexJoinsEnabled(false).setOptimizeHashGeneration(true);
        PlanOptimizersFactory planOptimizersFactory = new PlanOptimizersFactory(this.metadata, this.sqlParser, featuresConfig, true);
        QueryExplainer queryExplainer = new QueryExplainer((List<PlanOptimizer>)planOptimizersFactory.get(), (Metadata)this.metadata, (AccessControl)this.accessControl, this.sqlParser, (Map<Class<? extends Statement>, DataDefinitionTask<?>>)this.dataDefinitionTask, featuresConfig.isExperimentalSyntaxEnabled());
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(queryExplainer), featuresConfig.isExperimentalSyntaxEnabled());
        Analysis analysis = analyzer.analyze(statement);
        Plan plan = new LogicalPlanner(session, (List<PlanOptimizer>)planOptimizersFactory.get(), idAllocator, this.metadata).plan(analysis);
        if (this.printPlan) {
            System.out.println(PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, session));
        }
        if (!(subplan = new PlanFragmenter().createSubPlans(plan)).getChildren().isEmpty()) {
            throw new AssertionError((Object)"Expected subplan to have no children");
        }
        LocalExecutionPlanner executionPlanner = new LocalExecutionPlanner(this.metadata, this.sqlParser, this.pageSourceManager, this.indexManager, this.nodePartitioningManager, this.pageSinkManager, null, this.compiler, new IndexJoinLookupStats(), new CompilerConfig().setInterpreterEnabled(false), new TaskManagerConfig().setTaskDefaultConcurrency(4));
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = executionPlanner.plan(session, subplan.getFragment().getRoot(), subplan.getFragment().getPartitionFunction().getOutputLayout(), plan.getTypes(), outputFactory, true, false);
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : LocalQueryRunner.findTableScanNodes(subplan.getFragment().getRoot())) {
            TableLayoutHandle layout = tableScan.getLayout().get();
            SplitSource splitSource = this.splitManager.getSplits(session, layout);
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : (List)MoreFutures.getFutureValue(splitSource.getNextBatch(1000))) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, split));
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set<ScheduledSplit>)scheduledSplits.build(), true));
        }
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap<PlanNodeId, Driver> driversBySource = new HashMap<PlanNodeId, Driver>();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances(); ++i) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.isInputDriver(), driverFactory.isOutputDriver()).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
                for (PlanNodeId sourceId : driver.getSourceIds()) {
                    driversBySource.put(sourceId, driver);
                }
            }
            driverFactory.close();
        }
        for (TaskSource source : sources) {
            for (Driver driver : driversBySource.values()) {
                driver.updateSource(source);
            }
        }
        return ImmutableList.copyOf(drivers);
    }

    public OperatorFactory createTableScanOperator(int operatorId, PlanNodeId planNodeId, String tableName, String ... columnNames) {
        return this.createTableScanOperator(this.defaultSession, operatorId, planNodeId, tableName, columnNames);
    }

    public OperatorFactory createTableScanOperator(Session session, int operatorId, PlanNodeId planNodeId, String tableName, String ... columnNames) {
        Preconditions.checkArgument((boolean)session.getCatalog().isPresent(), (Object)"catalog not set");
        Preconditions.checkArgument((boolean)session.getSchema().isPresent(), (Object)"schema not set");
        QualifiedObjectName qualifiedTableName = new QualifiedObjectName(session.getCatalog().get(), session.getSchema().get(), tableName);
        TableHandle tableHandle = this.metadata.getTableHandle(session, qualifiedTableName).orElse(null);
        Preconditions.checkArgument((tableHandle != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{qualifiedTableName});
        Map<String, ColumnHandle> allColumnHandles = this.metadata.getColumnHandles(session, tableHandle);
        ImmutableList.Builder columnHandlesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnTypesBuilder = ImmutableList.builder();
        for (String columnName : columnNames) {
            ColumnHandle columnHandle = allColumnHandles.get(columnName);
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Table %s does not have a column %s", (Object[])new Object[]{tableName, columnName});
            columnHandlesBuilder.add((Object)columnHandle);
            ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(session, tableHandle, columnHandle);
            columnTypesBuilder.add((Object)columnMetadata.getType());
        }
        ImmutableList columnHandles = columnHandlesBuilder.build();
        ImmutableList columnTypes = columnTypesBuilder.build();
        List<TableLayoutResult> layouts = this.metadata.getLayouts(session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
        Split split = this.getLocalQuerySplit(session, layouts.get(0).getLayout().getHandle());
        return new OperatorFactory((List)columnTypes, operatorId, planNodeId, session, split, (List)columnHandles){
            final /* synthetic */ List val$columnTypes;
            final /* synthetic */ int val$operatorId;
            final /* synthetic */ PlanNodeId val$planNodeId;
            final /* synthetic */ Session val$session;
            final /* synthetic */ Split val$split;
            final /* synthetic */ List val$columnHandles;
            {
                this.val$columnTypes = list;
                this.val$operatorId = n;
                this.val$planNodeId = planNodeId;
                this.val$session = session;
                this.val$split = split;
                this.val$columnHandles = list2;
            }

            @Override
            public List<Type> getTypes() {
                return this.val$columnTypes;
            }

            @Override
            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.val$operatorId, this.val$planNodeId, "BenchmarkSource");
                ConnectorPageSource pageSource = LocalQueryRunner.this.pageSourceManager.createPageSource(this.val$session, this.val$split, this.val$columnHandles);
                return new PageSourceOperator(pageSource, this.val$columnTypes, operatorContext);
            }

            @Override
            public void close() {
            }

            @Override
            public OperatorFactory duplicate() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public OperatorFactory createHashProjectOperator(int operatorId, PlanNodeId planNodeId, List<Type> columnTypes) {
        ImmutableList.Builder projectionFunctions = ImmutableList.builder();
        for (int i = 0; i < columnTypes.size(); ++i) {
            projectionFunctions.add((Object)ProjectionFunctions.singleColumn(columnTypes.get(i), i));
        }
        projectionFunctions.add((Object)new HashProjectionFunction(columnTypes));
        return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(operatorId, planNodeId, () -> new GenericPageProcessor(FilterFunctions.TRUE_FUNCTION, (Iterable<? extends ProjectionFunction>)projectionFunctions.build()), (List<Type>)ImmutableList.copyOf((Iterable)Iterables.concat(columnTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))));
    }

    private Split getLocalQuerySplit(Session session, TableLayoutHandle handle) {
        SplitSource splitSource = this.splitManager.getSplits(session, handle);
        ArrayList splits = new ArrayList();
        splits.addAll((Collection)MoreFutures.getFutureValue(splitSource.getNextBatch(1000)));
        while (!splitSource.isFinished()) {
            splits.addAll((Collection)MoreFutures.getFutureValue(splitSource.getNextBatch(1000)));
        }
        Preconditions.checkArgument((splits.size() == 1 ? 1 : 0) != 0, (String)"Expected only one split for a local query, but got %s splits", (Object[])new Object[]{splits.size()});
        return (Split)splits.get(0);
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        ImmutableList.Builder tableScanNodes = ImmutableList.builder();
        LocalQueryRunner.findTableScanNodes(node, (ImmutableList.Builder<TableScanNode>)tableScanNodes);
        return tableScanNodes.build();
    }

    private static void findTableScanNodes(PlanNode node, ImmutableList.Builder<TableScanNode> builder) {
        for (PlanNode source : node.getSources()) {
            LocalQueryRunner.findTableScanNodes(source, builder);
        }
        if (node instanceof TableScanNode) {
            builder.add((Object)((TableScanNode)node));
        }
    }

    private static class HashProjectionFunction
    implements ProjectionFunction {
        private final List<Type> columnTypes;

        public HashProjectionFunction(List<Type> columnTypes) {
            this.columnTypes = columnTypes;
        }

        @Override
        public Type getType() {
            return BigintType.BIGINT;
        }

        @Override
        public void project(int position, Block[] blocks, BlockBuilder output) {
            BigintType.BIGINT.writeLong(output, (long)TypeUtils.getHashPosition(this.columnTypes, blocks, position));
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            throw new UnsupportedOperationException("Operation not supported");
        }

        @Override
        public Set<Integer> getInputChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDeterministic() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MaterializedOutputFactory
    implements OutputFactory {
        private final AtomicReference<MaterializedResult.Builder> materializedResultBuilder = new AtomicReference();

        public MaterializedResult getMaterializedResult() {
            MaterializedResult.Builder resultBuilder = this.materializedResultBuilder.get();
            Preconditions.checkState((resultBuilder != null ? 1 : 0) != 0, (Object)"Output not created");
            return resultBuilder.build();
        }

        @Override
        public OperatorFactory createOutputOperator(final int operatorId, final PlanNodeId planNodeId, final List<Type> sourceTypes) {
            Objects.requireNonNull(sourceTypes, "sourceType is null");
            return new OperatorFactory(){

                @Override
                public List<Type> getTypes() {
                    return ImmutableList.of();
                }

                @Override
                public Operator createOperator(DriverContext driverContext) {
                    MaterializedResult.Builder resultBuilder = (MaterializedResult.Builder)materializedResultBuilder.get();
                    if (resultBuilder == null) {
                        materializedResultBuilder.compareAndSet(null, MaterializedResult.resultBuilder(driverContext.getSession(), (Iterable<? extends Type>)sourceTypes));
                        resultBuilder = (MaterializedResult.Builder)materializedResultBuilder.get();
                    }
                    OperatorContext operatorContext = driverContext.addOperatorContext(operatorId, planNodeId, MaterializingOperator.class.getSimpleName());
                    return new MaterializingOperator(operatorContext, resultBuilder);
                }

                @Override
                public void close() {
                }

                @Override
                public OperatorFactory duplicate() {
                    return this.createOutputOperator(operatorId, planNodeId, sourceTypes);
                }
            };
        }
    }
}

