/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final List<PlanNode> sources;
    private final PartitionFunctionBinding partitionFunction;
    private final List<List<Symbol>> inputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="partitionFunction") PartitionFunctionBinding partitionFunction, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="inputs") List<List<Symbol>> inputs) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        Objects.requireNonNull(inputs, "inputs is null");
        Preconditions.checkArgument((boolean)inputs.stream().allMatch(inputSymbols -> inputSymbols.size() == partitionFunction.getOutputLayout().size()), (Object)"Input symbols do not match output symbols");
        Preconditions.checkArgument((inputs.size() == sources.size() ? 1 : 0) != 0, (Object)"Must have same number of input lists as sources");
        for (int i = 0; i < inputs.size(); ++i) {
            Preconditions.checkArgument((boolean)sources.get(i).getOutputSymbols().containsAll((Collection)inputs.get(i)), (Object)"Source does not supply all required input symbols");
        }
        this.type = type;
        this.sources = sources;
        this.partitionFunction = partitionFunction;
        this.inputs = ImmutableList.copyOf(inputs);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, PlanNode child, List<Symbol> partitioningColumns, Optional<Symbol> hashColumns) {
        return ExchangeNode.partitionedExchange(id, child, new PartitionFunctionBinding(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, child.getOutputSymbols(), (List)partitioningColumns.stream().map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).collect(ImmutableCollectors.toImmutableList()), hashColumns));
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, PlanNode child, PartitionFunctionBinding partitionFunction) {
        return new ExchangeNode(id, Type.REPARTITION, partitionFunction, (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode replicatedExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.REPLICATE, new PartitionFunctionBinding(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, child.getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, new PartitionFunctionBinding(SystemPartitioningHandle.SINGLE_DISTRIBUTION, child.getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()), (List<PlanNode>)ImmutableList.of((Object)child), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, List<Symbol> outputLayout, List<PlanNode> children) {
        return new ExchangeNode(id, Type.GATHER, new PartitionFunctionBinding(SystemPartitioningHandle.SINGLE_DISTRIBUTION, outputLayout, (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()), children, (List)children.stream().map(PlanNode::getOutputSymbols).collect(ImmutableCollectors.toImmutableList()));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.partitionFunction.getOutputLayout();
    }

    @JsonProperty
    public PartitionFunctionBinding getPartitionFunction() {
        return this.partitionFunction;
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

