/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class PropertyDerivations {
    private PropertyDerivations() {
    }

    public static ActualProperties deriveProperties(PlanNode node, ActualProperties inputProperties, Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
        return PropertyDerivations.deriveProperties(node, (List<ActualProperties>)ImmutableList.of((Object)inputProperties), metadata, session, types, parser);
    }

    public static ActualProperties deriveProperties(PlanNode node, List<ActualProperties> inputProperties, Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
        return node.accept(new Visitor(metadata, session, types, parser), inputProperties);
    }

    private static class Visitor
    extends PlanVisitor<List<ActualProperties>, ActualProperties> {
        private final Metadata metadata;
        private final Session session;
        private final Map<Symbol, Type> types;
        private final SqlParser parser;

        public Visitor(Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
            this.metadata = metadata;
            this.session = session;
            this.types = types;
            this.parser = parser;
        }

        @Override
        protected ActualProperties visitPlan(PlanNode node, List<ActualProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitOutput(OutputNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitEnforceSingleRow(EnforceSingleRowNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitMarkDistinct(MarkDistinctNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitWindow(WindowNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (ImmutableSet.copyOf(node.getPartitionBy()).equals(node.getPrePartitionedInputs()) && node.getPreSortedOrderPrefix() == node.getOrderBy().size()) {
                return properties;
            }
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (!node.getPrePartitionedInputs().isEmpty()) {
                GroupingProperty prePartitionedProperty = new GroupingProperty(node.getPrePartitionedInputs());
                for (LocalProperty<Symbol> localProperty : properties.getLocalProperties()) {
                    if (!prePartitionedProperty.isSimplifiedBy(localProperty)) break;
                    localProperties.add(localProperty);
                }
            }
            if (!node.getPartitionBy().isEmpty()) {
                localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            }
            for (Symbol column : node.getOrderBy()) {
                localProperties.add((Object)new SortingProperty((Object)column, node.getOrderings().get(column)));
            }
            return ActualProperties.builderFrom(properties).local(LocalProperties.normalizeAndPrune(localProperties.build())).build();
        }

        @Override
        public ActualProperties visitAggregation(AggregationNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translated = properties.translate(symbol -> node.getGroupBy().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return ActualProperties.builderFrom(translated).local(LocalProperties.grouped(node.getGroupBy())).build();
        }

        @Override
        public ActualProperties visitRowNumber(RowNumberNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitTopNRowNumber(TopNRowNumberNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder localProperties = ImmutableList.builder();
            localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            for (Symbol column : node.getOrderBy()) {
                localProperties.add((Object)new SortingProperty((Object)column, node.getOrderings().get(column)));
            }
            return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build();
        }

        @Override
        public ActualProperties visitTopN(TopNNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderBy().stream().map(column -> new SortingProperty(column, node.getOrderings().get(column))).collect(ImmutableCollectors.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        @Override
        public ActualProperties visitSort(SortNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderBy().stream().map(column -> new SortingProperty(column, node.getOrderings().get(column))).collect(ImmutableCollectors.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        @Override
        public ActualProperties visitLimit(LimitNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitDistinctLimit(DistinctLimitNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(LocalProperties.grouped(node.getDistinctSymbols())).build();
        }

        @Override
        public ActualProperties visitTableFinish(TableFinishNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
        }

        @Override
        public ActualProperties visitDelete(DeleteNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(symbol -> Optional.empty());
        }

        @Override
        public ActualProperties visitJoin(JoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            switch (node.getType()) {
                case INNER: {
                    return ActualProperties.builderFrom(probeProperties).constants((Map<Symbol, NullableValue>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(buildProperties.getConstants()).build()).build();
                }
                case LEFT: {
                    return ActualProperties.builderFrom(probeProperties).constants(probeProperties.getConstants()).build();
                }
                case RIGHT: {
                    return ActualProperties.builderFrom(buildProperties).constants(buildProperties.getConstants()).local((List<? extends LocalProperty<Symbol>>)ImmutableList.of()).build();
                }
                case FULL: {
                    return ActualProperties.builder().global(probeProperties.isSingleNode() ? ActualProperties.Global.singleStreamPartition() : ActualProperties.Global.arbitraryPartition()).build();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public ActualProperties visitSemiJoin(SemiJoinNode node, List<ActualProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public ActualProperties visitIndexJoin(IndexJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties indexProperties = inputProperties.get(1);
            switch (node.getType()) {
                case INNER: {
                    return ActualProperties.builderFrom(probeProperties).constants((Map<Symbol, NullableValue>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(indexProperties.getConstants()).build()).build();
                }
                case SOURCE_OUTER: {
                    return ActualProperties.builderFrom(probeProperties).constants(probeProperties.getConstants()).build();
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public ActualProperties visitIndexSource(IndexSourceNode node, List<ActualProperties> context) {
            return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build();
        }

        public static Map<Symbol, Symbol> exchangeInputToOutput(ExchangeNode node, int sourceIndex) {
            List<Symbol> inputSymbols = node.getInputs().get(sourceIndex);
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                inputToOutput.put(inputSymbols.get(i), node.getOutputSymbols().get(i));
            }
            return inputToOutput;
        }

        @Override
        public ActualProperties visitExchange(ExchangeNode node, List<ActualProperties> inputProperties) {
            Sets.SetView entries = null;
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                Map<Symbol, Symbol> inputToOutput = Visitor.exchangeInputToOutput(node, sourceIndex);
                ActualProperties translated = inputProperties.get(sourceIndex).translate(symbol -> Optional.ofNullable(inputToOutput.get(symbol)));
                entries = entries == null ? translated.getConstants().entrySet() : Sets.intersection(entries, translated.getConstants().entrySet());
            }
            Preconditions.checkState((entries != null ? 1 : 0) != 0);
            Map<Symbol, NullableValue> constants = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            switch (node.getType()) {
                case GATHER: {
                    return ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).constants(constants).build();
                }
                case REPARTITION: {
                    return ActualProperties.builder().global(ActualProperties.Global.partitionedOn(node.getPartitionFunction().getPartitioningHandle(), node.getPartitionFunction().getPartitionFunctionArguments(), Optional.of(node.getPartitionFunction().getPartitionFunctionArguments()))).constants(constants).build();
                }
                case REPLICATE: {
                    return ActualProperties.builder().global(ActualProperties.Global.arbitraryPartition()).constants(constants).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented");
        }

        @Override
        public ActualProperties visitFilter(FilterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, this.session, node.getPredicate(), this.types);
            HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>(properties.getConstants());
            constants.putAll((Map)TupleDomain.extractFixedValues(decomposedPredicate.getTupleDomain()).orElse(ImmutableMap.of()));
            return ActualProperties.builderFrom(properties).constants(constants).build();
        }

        @Override
        public ActualProperties visitProject(ProjectNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            Map<Symbol, Symbol> identities = Visitor.computeIdentityTranslations(node.getAssignments());
            ActualProperties translatedProperties = properties.translate(column -> Optional.ofNullable(identities.get(column)));
            HashMap<Symbol, NullableValue> constants = new HashMap<Symbol, NullableValue>();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                Expression expression = assignment.getValue();
                IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.parser, this.types, expression);
                Type type = Objects.requireNonNull(expressionTypes.get(expression));
                ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes);
                Object value = optimizer.optimize(NoOpSymbolResolver.INSTANCE);
                if (value instanceof QualifiedNameReference) {
                    Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)value).getName());
                    NullableValue existingConstantValue = (NullableValue)constants.get(symbol);
                    if (existingConstantValue == null) continue;
                    constants.put(assignment.getKey(), new NullableValue(type, value));
                    continue;
                }
                if (value instanceof Expression) continue;
                constants.put(assignment.getKey(), new NullableValue(type, value));
            }
            constants.putAll(translatedProperties.getConstants());
            return ActualProperties.builderFrom(translatedProperties).constants(constants).build();
        }

        @Override
        public ActualProperties visitTableWriter(TableWriterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.isCoordinatorOnly()) {
                return ActualProperties.builder().global(ActualProperties.Global.coordinatorSingleStreamPartition()).build();
            }
            return ActualProperties.builder().global(properties.isSingleNode() ? ActualProperties.Global.singleStreamPartition() : ActualProperties.Global.arbitraryPartition()).build();
        }

        @Override
        public ActualProperties visitSample(SampleNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitUnnest(UnnestNode node, List<ActualProperties> inputProperties) {
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateSymbols());
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(arg_0 -> Visitor.lambda$visitUnnest$361((Set)passThroughInputs, arg_0));
        }

        @Override
        public ActualProperties visitTableScan(TableScanNode node, List<ActualProperties> inputProperties) {
            Preconditions.checkArgument((boolean)node.getLayout().isPresent(), (Object)"table layout has not yet been chosen");
            TableLayout layout = this.metadata.getLayout(this.session, node.getLayout().get());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            ActualProperties.Builder properties = ActualProperties.builder();
            HashMap<ColumnHandle, NullableValue> globalConstants = new HashMap<ColumnHandle, NullableValue>();
            ((Map)TupleDomain.extractFixedValues(node.getCurrentConstraint()).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !((NullableValue)entry.getValue()).isNull()).forEach(entry -> {
                NullableValue cfr_ignored_0 = (NullableValue)globalConstants.put((ColumnHandle)entry.getKey(), (NullableValue)entry.getValue());
            });
            Map<Symbol, NullableValue> symbolConstants = globalConstants.entrySet().stream().filter(arg_0 -> Visitor.lambda$visitTableScan$364((Map)assignments, arg_0)).collect(Collectors.toMap(arg_0 -> Visitor.lambda$visitTableScan$365((Map)assignments, arg_0), Map.Entry::getValue));
            properties.constants(symbolConstants);
            properties.global(this.deriveGlobalProperties(layout, (Map<ColumnHandle, Symbol>)assignments, globalConstants));
            ImmutableList constantAppendedLocalProperties = ImmutableList.builder().addAll(globalConstants.keySet().stream().map(column -> new ConstantProperty(column)).iterator()).addAll(layout.getLocalProperties()).build();
            properties.local(LocalProperties.translate(constantAppendedLocalProperties, arg_0 -> Visitor.lambda$visitTableScan$367((Map)assignments, arg_0)));
            return properties.build();
        }

        private ActualProperties.Global deriveGlobalProperties(TableLayout layout, Map<ColumnHandle, Symbol> assignments, Map<ColumnHandle, NullableValue> constants) {
            Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> partitioning = layout.getPartitioningColumns().flatMap(columns -> Visitor.translateToNonConstantSymbols(columns, assignments, constants));
            if (SystemSessionProperties.planWithTableNodePartitioning(this.session) && layout.getNodePartitioning().isPresent()) {
                TableLayout.NodePartitioning nodePartitioning = layout.getNodePartitioning().get();
                if (assignments.keySet().containsAll(nodePartitioning.getPartitioningColumns())) {
                    List arguments = (List)nodePartitioning.getPartitioningColumns().stream().map(assignments::get).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).collect(ImmutableCollectors.toImmutableList());
                    return ActualProperties.Global.partitionedOn(nodePartitioning.getPartitioningHandle(), arguments, partitioning);
                }
            }
            if (partitioning.isPresent()) {
                return ActualProperties.Global.streamPartitionedOn((List)partitioning.get());
            }
            return ActualProperties.Global.arbitraryPartition();
        }

        private static Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> translateToNonConstantSymbols(Set<ColumnHandle> columnHandles, Map<ColumnHandle, Symbol> assignments, Map<ColumnHandle, NullableValue> globalConstants) {
            Set constantsStrippedColumns = (Set)columnHandles.stream().filter(column -> !globalConstants.containsKey(column)).collect(ImmutableCollectors.toImmutableSet());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ColumnHandle column2 : constantsStrippedColumns) {
                Symbol translated = assignments.get(column2);
                if (translated == null) {
                    return Optional.empty();
                }
                builder.add((Object)new PartitionFunctionBinding.PartitionFunctionArgumentBinding(translated));
            }
            return Optional.of(ImmutableList.copyOf((Collection)builder.build()));
        }

        private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                if (!(assignment.getValue() instanceof QualifiedNameReference)) continue;
                inputToOutput.put(Symbol.fromQualifiedName(((QualifiedNameReference)assignment.getValue()).getName()), assignment.getKey());
            }
            return inputToOutput;
        }

        private static /* synthetic */ Optional lambda$visitTableScan$367(Map assignments, ColumnHandle column) {
            return Optional.ofNullable(assignments.get(column));
        }

        private static /* synthetic */ Symbol lambda$visitTableScan$365(Map assignments, Map.Entry entry) {
            return (Symbol)assignments.get(entry.getKey());
        }

        private static /* synthetic */ boolean lambda$visitTableScan$364(Map assignments, Map.Entry entry) {
            return assignments.containsKey(entry.getKey());
        }

        private static /* synthetic */ Optional lambda$visitUnnest$361(Set passThroughInputs, Symbol column) {
            if (passThroughInputs.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }
    }
}

