/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class PartitioningHandle {
    private final Optional<String> connectorId;
    private final Optional<ConnectorTransactionHandle> transactionHandle;
    private final ConnectorPartitioningHandle connectorHandle;

    @JsonCreator
    public PartitioningHandle(@JsonProperty(value="connectorId") Optional<String> connectorId, @JsonProperty(value="transactionHandle") Optional<ConnectorTransactionHandle> transactionHandle, @JsonProperty(value="connectorHandle") ConnectorPartitioningHandle connectorHandle) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        Preconditions.checkArgument((!connectorId.isPresent() || transactionHandle.isPresent() ? 1 : 0) != 0, (Object)"transactionHandle is required when connectorId is present");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
    }

    @JsonProperty
    public Optional<String> getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public Optional<ConnectorTransactionHandle> getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorPartitioningHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    public boolean isSingleNode() {
        return this.connectorHandle.isSingleNode();
    }

    public boolean isCoordinatorOnly() {
        return this.connectorHandle.isCoordinatorOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningHandle that = (PartitioningHandle)o;
        if (this.connectorId.isPresent() || that.connectorId.isPresent()) {
            return false;
        }
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.transactionHandle, that.transactionHandle) && Objects.equals(this.connectorHandle, that.connectorHandle);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.transactionHandle, this.connectorHandle);
    }

    public String toString() {
        if (this.connectorId.isPresent()) {
            return this.connectorId.get() + ":" + this.connectorHandle;
        }
        return this.connectorHandle.toString();
    }
}

