/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.PlanSanityChecker;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final SymbolAllocator symbolAllocator = new SymbolAllocator();
    private final Metadata metadata;

    public LogicalPlanner(Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.session = session;
        this.planOptimizers = planOptimizers;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public Plan plan(Analysis analysis) {
        RelationPlan plan = analysis.getCreateTableDestination().isPresent() ? this.createTableCreationPlan(analysis) : (analysis.getInsert().isPresent() ? this.createInsertPlan(analysis) : (analysis.getDelete().isPresent() ? this.createDeletePlan(analysis) : this.createRelationPlan(analysis)));
        PlanNode root = this.createOutputPlan(plan, analysis);
        PlanSanityChecker.validate(root);
        for (PlanOptimizer optimizer : this.planOptimizers) {
            root = optimizer.optimize(root, this.session, this.symbolAllocator.getTypes(), this.symbolAllocator, this.idAllocator);
            Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
        }
        PlanSanityChecker.validate(root);
        return new Plan(root, this.symbolAllocator);
    }

    private RelationPlan createTableCreationPlan(Analysis analysis) {
        QualifiedObjectName destination = analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis);
        TableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan), analysis.getCreateTableProperties(), plan.getSampleWeight().isPresent());
        if (plan.getSampleWeight().isPresent() && !this.metadata.canCreateSampledTables(this.session, destination.getCatalogName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write sampled data to a store that doesn't support sampling");
        }
        Optional<NewTableLayout> newTableLayout = this.metadata.getNewTableLayout(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateName(destination.getCatalogName(), tableMetadata, newTableLayout), tableMetadata.getVisibleColumnNames(), newTableLayout);
    }

    private RelationPlan createInsertPlan(Analysis analysis) {
        Analysis.Insert insert = analysis.getInsert().get();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, insert.getTarget());
        List<String> visibleTableColumnNames = tableMetadata.getVisibleColumnNames();
        List<ColumnMetadata> visibleTableColumns = tableMetadata.getVisibleColumns();
        RelationPlan plan = this.createRelationPlan(analysis);
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, insert.getTarget());
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (ColumnMetadata column2 : tableMetadata.getVisibleColumns()) {
            Symbol output = this.symbolAllocator.newSymbol(column2.getName(), column2.getType());
            int index = insert.getColumns().indexOf(columns.get(column2.getName()));
            if (index < 0) {
                assignments.put((Object)output, (Object)new NullLiteral());
                continue;
            }
            assignments.put((Object)output, (Object)plan.getSymbol(index).toQualifiedNameReference());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), (Map<Symbol, Expression>)assignments.build());
        RelationType tupleDescriptor = new RelationType((List)visibleTableColumns.stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableCollectors.toImmutableList()));
        plan = new RelationPlan(projectNode, tupleDescriptor, projectNode.getOutputSymbols(), plan.getSampleWeight());
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, insert.getTarget());
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.InsertReference(insert.getTarget()), visibleTableColumnNames, newTableLayout);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, Optional<NewTableLayout> writeTableLayout) {
        ImmutableList writerOutputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(this.idAllocator.getNextId(), source, 0L);
        }
        writeTableLayout.ifPresent(layout -> {
            if (!ImmutableSet.copyOf((Collection)columnNames).containsAll(layout.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
            }
        });
        List<Symbol> symbols = plan.getOutputSymbols();
        Optional<PartitionFunctionBinding> partitionFunctionBinding = Optional.empty();
        if (writeTableLayout.isPresent()) {
            ArrayList<PartitionFunctionBinding.PartitionFunctionArgumentBinding> partitionFunctionArguments = new ArrayList<PartitionFunctionBinding.PartitionFunctionArgumentBinding>();
            writeTableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(symbols::get).map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).forEach(partitionFunctionArguments::add);
            plan.getSampleWeight().map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).ifPresent(partitionFunctionArguments::add);
            ArrayList<Symbol> outputLayout = new ArrayList<Symbol>(symbols);
            plan.getSampleWeight().ifPresent(outputLayout::add);
            partitionFunctionBinding = Optional.of(new PartitionFunctionBinding(writeTableLayout.get().getPartitioning(), outputLayout, partitionFunctionArguments));
        }
        TableWriterNode writerNode = new TableWriterNode(this.idAllocator.getNextId(), source, target, symbols, columnNames, (List<Symbol>)writerOutputs, plan.getSampleWeight(), partitionFunctionBinding);
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), writerNode, target, (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), (List<Symbol>)outputs, Optional.empty());
    }

    private RelationPlan createDeletePlan(Analysis analysis) {
        QueryPlanner planner = new QueryPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        DeleteNode deleteNode = planner.planDelete(analysis.getDelete().get());
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT));
        TableFinishNode commitNode = new TableFinishNode(this.idAllocator.getNextId(), deleteNode, deleteNode.getTarget(), (List<Symbol>)outputs);
        return new RelationPlan(commitNode, analysis.getOutputDescriptor(), commitNode.getOutputSymbols(), Optional.empty());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            Symbol symbol = plan.getSymbol(fieldIndex);
            outputs.add((Object)symbol);
            ++columnNumber;
        }
        return new OutputNode(this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis) {
        return (RelationPlan)new RelationPlanner(analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)analysis.getQuery(), null);
    }

    private TableMetadata createTableMetadata(QualifiedObjectName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, boolean sampled) {
        String owner = this.session.getUser();
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getTableProperties(table.getCatalogName(), propertyExpressions, this.session, this.metadata);
        ConnectorTableMetadata metadata = new ConnectorTableMetadata(table.asSchemaTableName(), columns, properties, owner, sampled);
        return new TableMetadata(table.getCatalogName(), metadata);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            columns.add((Object)new ColumnMetadata(field.getName().get(), field.getType()));
        }
        return columns.build();
    }
}

