/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.predicate.DiscreteValues;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.Ranges;
import com.facebook.presto.spi.predicate.SortedRangeSet;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DomainTranslator {
    private DomainTranslator() {
    }

    public static Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        if (tupleDomain.isNone()) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        ImmutableList.Builder conjunctBuilder = ImmutableList.builder();
        for (Map.Entry entry : ((Map)tupleDomain.getDomains().get()).entrySet()) {
            Symbol symbol = (Symbol)entry.getKey();
            QualifiedNameReference reference = new QualifiedNameReference(symbol.toQualifiedName());
            conjunctBuilder.add((Object)DomainTranslator.toPredicate((Domain)entry.getValue(), reference));
        }
        return ExpressionUtils.combineConjuncts((Iterable<Expression>)conjunctBuilder.build());
    }

    private static Expression toPredicate(Domain domain, QualifiedNameReference reference) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? new IsNullPredicate((Expression)reference) : BooleanLiteral.FALSE_LITERAL;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? BooleanLiteral.TRUE_LITERAL : new NotExpression((Expression)new IsNullPredicate((Expression)reference));
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        disjuncts.addAll((Collection)domain.getValues().getValuesProcessor().transform(ranges -> DomainTranslator.extractDisjuncts(domain.getType(), ranges, reference), discreteValues -> DomainTranslator.extractDisjuncts(domain.getType(), discreteValues, reference), allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        }));
        if (domain.isNullAllowed()) {
            disjuncts.add((Expression)new IsNullPredicate((Expression)reference));
        }
        return ExpressionUtils.combineDisjunctsWithDefault(disjuncts, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private static Expression processRange(Type type, Range range, QualifiedNameReference reference) {
        if (range.isAll()) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        if (DomainTranslator.isBetween(range)) {
            return new BetweenPredicate((Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type), LiteralInterpreter.toExpression(range.getHigh().getValue(), type));
        }
        ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
        if (!range.getLow().isLowerUnbounded()) {
            switch (range.getLow().getBound()) {
                case ABOVE: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type)));
                    break;
                }
                case EXACTLY: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getLow().getValue(), type)));
                    break;
                }
                case BELOW: {
                    throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                }
            }
        }
        if (!range.getHigh().isUpperUnbounded()) {
            switch (range.getHigh().getBound()) {
                case ABOVE: {
                    throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                }
                case EXACTLY: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue(), type)));
                    break;
                }
                case BELOW: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.LESS_THAN, (Expression)reference, LiteralInterpreter.toExpression(range.getHigh().getValue(), type)));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                }
            }
        }
        Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
        return ExpressionUtils.combineConjuncts(rangeConjuncts);
    }

    private static Expression combineRangeWithExcludedPoints(Type type, QualifiedNameReference reference, Range range, List<Expression> excludedPoints) {
        if (excludedPoints.isEmpty()) {
            return DomainTranslator.processRange(type, range, reference);
        }
        NotExpression excludedPointsExpression = new NotExpression((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(excludedPoints)));
        if (excludedPoints.size() == 1) {
            excludedPointsExpression = new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(excludedPoints));
        }
        return ExpressionUtils.combineConjuncts(new Expression[]{DomainTranslator.processRange(type, range, reference), excludedPointsExpression});
    }

    private static List<Expression> extractDisjuncts(Type type, Ranges ranges, QualifiedNameReference reference) {
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        List orderedRanges = ranges.getOrderedRanges();
        SortedRangeSet sortedRangeSet = SortedRangeSet.copyOf((Type)type, (List)orderedRanges);
        SortedRangeSet complement = sortedRangeSet.complement();
        List singleValueExclusionsList = complement.getOrderedRanges().stream().filter(Range::isSingleValue).collect(Collectors.toList());
        List originalUnionSingleValues = SortedRangeSet.copyOf((Type)type, singleValueExclusionsList).union((ValueSet)sortedRangeSet).getOrderedRanges();
        PeekingIterator singleValueExclusions = Iterators.peekingIterator(singleValueExclusionsList.iterator());
        for (Range range : originalUnionSingleValues) {
            if (range.isSingleValue()) {
                singleValues.add(LiteralInterpreter.toExpression(range.getSingleValue(), type));
                continue;
            }
            ArrayList<Expression> singleValuesInRange = new ArrayList<Expression>();
            while (singleValueExclusions.hasNext() && range.contains((Range)singleValueExclusions.peek())) {
                singleValuesInRange.add(LiteralInterpreter.toExpression(((Range)singleValueExclusions.next()).getSingleValue(), type));
            }
            if (!singleValuesInRange.isEmpty()) {
                disjuncts.add(DomainTranslator.combineRangeWithExcludedPoints(type, reference, range, singleValuesInRange));
                continue;
            }
            disjuncts.add(DomainTranslator.processRange(type, range, reference));
        }
        if (singleValues.size() == 1) {
            disjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(singleValues)));
        }
        return disjuncts;
    }

    private static List<Expression> extractDisjuncts(Type type, DiscreteValues discreteValues, QualifiedNameReference reference) {
        List values = discreteValues.getValues().stream().map(object -> LiteralInterpreter.toExpression(object, type)).collect(Collectors.toList());
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        Object predicate = values.size() == 1 ? new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(values)) : new InPredicate((Expression)reference, (Expression)new InListExpression(values));
        if (!discreteValues.isWhiteList()) {
            predicate = new NotExpression((Expression)predicate);
        }
        return ImmutableList.of((Object)predicate);
    }

    private static boolean isBetween(Range range) {
        return !range.getLow().isLowerUnbounded() && range.getLow().getBound() == Marker.Bound.EXACTLY && !range.getHigh().isUpperUnbounded() && range.getHigh().getBound() == Marker.Bound.EXACTLY;
    }

    public static ExtractionResult fromPredicate(Metadata metadata, Session session, Expression predicate, Map<Symbol, Type> types) {
        return (ExtractionResult)new Visitor(metadata, session, types).process((Node)predicate, false);
    }

    private static Optional<NormalizedSimpleComparison> toNormalizedSimpleComparison(Session session, Metadata metadata, Map<Symbol, Type> types, ComparisonExpression comparison) {
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, new SqlParser(), types, (Expression)comparison);
        Object left = ExpressionInterpreter.expressionOptimizer(comparison.getLeft(), metadata, session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
        Object right = ExpressionInterpreter.expressionOptimizer(comparison.getRight(), metadata, session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
        if (left instanceof QualifiedNameReference && !(right instanceof Expression)) {
            return Optional.of(new NormalizedSimpleComparison((QualifiedNameReference)left, comparison.getType(), new NullableValue(expressionTypes.get(comparison.getRight()), right)));
        }
        if (right instanceof QualifiedNameReference && !(left instanceof Expression)) {
            return Optional.of(new NormalizedSimpleComparison((QualifiedNameReference)right, comparison.getType().flip(), new NullableValue(expressionTypes.get(comparison.getLeft()), left)));
        }
        return Optional.empty();
    }

    private static Expression coerceDoubleToLongComparison(NormalizedSimpleComparison normalized) {
        Preconditions.checkArgument((boolean)normalized.getValue().getType().equals(DoubleType.DOUBLE), (Object)"Value should be of DOUBLE type");
        Preconditions.checkArgument((!normalized.getValue().isNull() ? 1 : 0) != 0, (Object)"Value should not be null");
        QualifiedNameReference reference = normalized.getNameReference();
        Double value = (Double)normalized.getValue().getValue();
        switch (normalized.getComparisonType()) {
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: {
                return new ComparisonExpression(normalized.getComparisonType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.CEILING), (Type)BigintType.BIGINT));
            }
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return new ComparisonExpression(normalized.getComparisonType(), (Expression)reference, LiteralInterpreter.toExpression(DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR), (Type)BigintType.BIGINT));
            }
            case EQUAL: {
                Long equalValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (equalValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(normalized.getComparisonType(), (Expression)reference, LiteralInterpreter.toExpression(equalValue, (Type)BigintType.BIGINT));
            }
            case NOT_EQUAL: {
                Long notEqualValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (notEqualValue.doubleValue() != value.doubleValue()) {
                    return ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)reference, (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Type.NOT_EQUAL, (Expression)reference, (Expression)new LongLiteral("0"))});
                }
                return new ComparisonExpression(normalized.getComparisonType(), (Expression)reference, LiteralInterpreter.toExpression(notEqualValue, (Type)BigintType.BIGINT));
            }
            case IS_DISTINCT_FROM: {
                Long distinctValue = DoubleMath.roundToLong((double)value, (RoundingMode)RoundingMode.FLOOR);
                if (distinctValue.doubleValue() != value.doubleValue()) {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                return new ComparisonExpression(normalized.getComparisonType(), (Expression)reference, LiteralInterpreter.toExpression(distinctValue, (Type)BigintType.BIGINT));
            }
        }
        throw new AssertionError((Object)("Unhandled type: " + normalized.getComparisonType()));
    }

    public static class ExtractionResult {
        private final TupleDomain<Symbol> tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<Symbol> getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class NormalizedSimpleComparison {
        private final QualifiedNameReference nameReference;
        private final ComparisonExpression.Type comparisonType;
        private final NullableValue value;

        public NormalizedSimpleComparison(QualifiedNameReference nameReference, ComparisonExpression.Type comparisonType, NullableValue value) {
            this.nameReference = Objects.requireNonNull(nameReference, "nameReference is null");
            this.comparisonType = Objects.requireNonNull(comparisonType, "comparisonType is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public QualifiedNameReference getNameReference() {
            return this.nameReference;
        }

        public ComparisonExpression.Type getComparisonType() {
            return this.comparisonType;
        }

        public NullableValue getValue() {
            return this.value;
        }
    }

    private static class Visitor
    extends AstVisitor<ExtractionResult, Boolean> {
        private final Metadata metadata;
        private final Session session;
        private final Map<Symbol, Type> types;

        private Visitor(Metadata metadata, Session session, Map<Symbol, Type> types) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
        }

        private Type checkedTypeLookup(Symbol symbol) {
            Type type = this.types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Types is missing info for symbol: %s", (Object[])new Object[]{symbol});
            return type;
        }

        private static ValueSet complementIfNecessary(ValueSet valueSet, boolean complement) {
            return complement ? valueSet.complement() : valueSet;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new NotExpression(expression) : expression;
        }

        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        protected ExtractionResult visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean complement) {
            ExtractionResult leftResult = (ExtractionResult)this.process((Node)node.getLeft(), complement);
            ExtractionResult rightResult = (ExtractionResult)this.process((Node)node.getRight(), complement);
            TupleDomain<Symbol> leftTupleDomain = leftResult.getTupleDomain();
            TupleDomain<Symbol> rightTupleDomain = rightResult.getTupleDomain();
            LogicalBinaryExpression.Type type = complement != false ? Visitor.flipLogicalBinaryType(node.getType()) : node.getType();
            switch (type) {
                case AND: {
                    return new ExtractionResult((TupleDomain<Symbol>)leftTupleDomain.intersect(rightTupleDomain), ExpressionUtils.combineConjuncts(leftResult.getRemainingExpression(), rightResult.getRemainingExpression()));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion(leftTupleDomain, rightTupleDomain, (TupleDomain[])new TupleDomain[0]);
                    Expression remainingExpression = Visitor.complementIfNecessary((Expression)node, (boolean)complement);
                    if (leftResult.getRemainingExpression().equals((Object)rightResult.getRemainingExpression()) && DeterminismEvaluator.isDeterministic(leftResult.getRemainingExpression())) {
                        boolean oneSideIsSuperSet;
                        boolean matchingSingleSymbolDomains = !leftTupleDomain.isNone() && !rightTupleDomain.isNone() && ((Map)leftTupleDomain.getDomains().get()).size() == 1 && ((Map)rightTupleDomain.getDomains().get()).size() == 1 && ((Map)leftTupleDomain.getDomains().get()).keySet().equals(((Map)rightTupleDomain.getDomains().get()).keySet());
                        boolean bl = oneSideIsSuperSet = leftTupleDomain.contains(rightTupleDomain) || rightTupleDomain.contains(leftTupleDomain);
                        if (matchingSingleSymbolDomains || oneSideIsSuperSet) {
                            remainingExpression = leftResult.getRemainingExpression();
                        }
                    }
                    return new ExtractionResult((TupleDomain<Symbol>)columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown type: " + node.getType()));
        }

        private static LogicalBinaryExpression.Type flipLogicalBinaryType(LogicalBinaryExpression.Type type) {
            switch (type) {
                case AND: {
                    return LogicalBinaryExpression.Type.OR;
                }
                case OR: {
                    return LogicalBinaryExpression.Type.AND;
                }
            }
            throw new AssertionError((Object)("Unknown type: " + type));
        }

        protected ExtractionResult visitNotExpression(NotExpression node, Boolean complement) {
            return (ExtractionResult)this.process((Node)node.getValue(), complement == false);
        }

        protected ExtractionResult visitComparisonExpression(ComparisonExpression node, Boolean complement) {
            Optional optionalNormalized = DomainTranslator.toNormalizedSimpleComparison(this.session, this.metadata, this.types, node);
            if (!optionalNormalized.isPresent()) {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            NormalizedSimpleComparison normalized = (NormalizedSimpleComparison)optionalNormalized.get();
            Symbol symbol = Symbol.fromQualifiedName(normalized.getNameReference().getName());
            Type fieldType = this.checkedTypeLookup(symbol);
            NullableValue value = normalized.getValue();
            if (value.getType().equals(DoubleType.DOUBLE) && fieldType.equals(BigintType.BIGINT)) {
                return (ExtractionResult)this.process((Node)DomainTranslator.coerceDoubleToLongComparison(normalized), complement);
            }
            Optional<NullableValue> coercedValue = this.coerce(value, fieldType);
            if (!coercedValue.isPresent()) {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            return this.createComparisonExtractionResult(normalized.getComparisonType(), symbol, fieldType, coercedValue.get().getValue(), complement);
        }

        private Optional<NullableValue> coerce(NullableValue value, Type targetType) {
            if (!TypeRegistry.canCoerce(value.getType(), targetType)) {
                return Optional.empty();
            }
            if (value.isNull()) {
                return Optional.of(NullableValue.asNull((Type)targetType));
            }
            Object coercedValue = new FunctionInvoker(this.metadata.getFunctionRegistry()).invoke(this.metadata.getFunctionRegistry().getCoercion(value.getType(), targetType), this.session.toConnectorSession(), value.getValue());
            return Optional.of(NullableValue.of((Type)targetType, (Object)coercedValue));
        }

        private ExtractionResult createComparisonExtractionResult(ComparisonExpression.Type comparisonType, Symbol column, Type type, @Nullable Object value, boolean complement) {
            Domain domain;
            if (value == null) {
                switch (comparisonType) {
                    case EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case NOT_EQUAL: {
                        return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                    case IS_DISTINCT_FROM: {
                        Domain domain2 = Visitor.complementIfNecessary(Domain.notNull((Type)type), complement);
                        return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL);
                    }
                }
                throw new AssertionError((Object)("Unhandled type: " + comparisonType));
            }
            if (type.isOrderable()) {
                domain = Visitor.extractOrderableDomain(comparisonType, type, value, complement);
            } else if (type.isComparable()) {
                domain = Visitor.extractEquatableDomain(comparisonType, type, value, complement);
            } else {
                throw new AssertionError((Object)("Type cannot be used in a comparison expression (should have been caught in analysis): " + type));
            }
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private static Domain extractOrderableDomain(ComparisonExpression.Type comparisonType, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            switch (comparisonType) {
                case EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case GREATER_THAN: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case LESS_THAN: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case NOT_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), complement), (boolean)false);
                }
                case IS_DISTINCT_FROM: {
                    return Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), (boolean)true), complement);
                }
            }
            throw new AssertionError((Object)("Unhandled type: " + comparisonType));
        }

        private static Domain extractEquatableDomain(ComparisonExpression.Type comparisonType, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            switch (comparisonType) {
                case EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]), complement), (boolean)false);
                }
                case NOT_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), complement), (boolean)false);
                }
                case IS_DISTINCT_FROM: {
                    return Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), (boolean)true), complement);
                }
            }
            throw new AssertionError((Object)("Unhandled type: " + comparisonType));
        }

        protected ExtractionResult visitInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference) || !(node.getValueList() instanceof InListExpression)) {
                return (ExtractionResult)super.visitInPredicate(node, (Object)complement);
            }
            InListExpression valueList = (InListExpression)node.getValueList();
            Preconditions.checkState((!valueList.getValues().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : valueList.getValues()) {
                disjuncts.add((Object)new ComparisonExpression(ComparisonExpression.Type.EQUAL, node.getValue(), expression));
            }
            return (ExtractionResult)this.process((Node)ExpressionUtils.or((Iterable<Expression>)disjuncts.build()), complement);
        }

        protected ExtractionResult visitBetweenPredicate(BetweenPredicate node, Boolean complement) {
            return (ExtractionResult)this.process((Node)ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), new ComparisonExpression(ComparisonExpression.Type.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax())}), complement);
        }

        protected ExtractionResult visitIsNullPredicate(IsNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitIsNotNullPredicate(IsNotNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof QualifiedNameReference)) {
                return (ExtractionResult)super.visitIsNotNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)node.getValue()).getName());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.notNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitBooleanLiteral(BooleanLiteral node, Boolean complement) {
            boolean value = complement.booleanValue() ? !node.getValue() : node.getValue();
            return new ExtractionResult((TupleDomain<Symbol>)(value ? TupleDomain.all() : TupleDomain.none()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitNullLiteral(NullLiteral node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
    }
}

