/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class FunctionInvoker {
    private final FunctionRegistry registry;

    public FunctionInvoker(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public Object invoke(Signature function, ConnectorSession session, Object ... arguments) {
        return this.invoke(function, session, Arrays.asList(arguments));
    }

    public Object invoke(Signature function, ConnectorSession session, List<Object> arguments) {
        MethodHandle method = this.registry.getScalarFunctionImplementation(function).getMethodHandle();
        ArrayList<Object> actualArguments = new ArrayList<Object>(arguments.size() + 1);
        Iterator<Object> iterator = arguments.iterator();
        for (int i = 0; i < method.type().parameterCount(); ++i) {
            if (method.type().parameterType(i) == ConnectorSession.class) {
                actualArguments.add(session);
                continue;
            }
            Preconditions.checkArgument((boolean)iterator.hasNext(), (String)"Not enough arguments provided for method: %s", (Object[])new Object[]{method.type()});
            actualArguments.add(iterator.next());
        }
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (String)"Too many arguments provided for method: %s", (Object[])new Object[]{method.type()});
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

