/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.split.SplitSource;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final String connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(String connectorId, ConnectorTransactionHandle transactionHandle, ConnectorSplitSource source) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    @Override
    public String getDataSourceName() {
        return this.source.getDataSourceName();
    }

    @Override
    public CompletableFuture<List<Split>> getNextBatch(int maxSize) {
        return this.source.getNextBatch(maxSize).thenApply(splits -> Lists.transform((List)splits, split -> new Split(this.connectorId, this.transactionHandle, (ConnectorSplit)split)));
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    public String toString() {
        return this.connectorId + ":" + this.source;
    }
}

