/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ScalarFunctionImplementation {
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final MethodHandle methodHandle;
    private final Optional<MethodHandle> instanceFactory;
    private final boolean deterministic;

    public ScalarFunctionImplementation(boolean nullable, List<Boolean> nullableArguments, MethodHandle methodHandle, boolean deterministic) {
        this(nullable, nullableArguments, methodHandle, Optional.empty(), deterministic);
    }

    public ScalarFunctionImplementation(boolean nullable, List<Boolean> nullableArguments, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean deterministic) {
        this.nullable = nullable;
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
        this.deterministic = deterministic;
        if (instanceFactory.isPresent()) {
            TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
            Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.instanceFactory;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }
}

