/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RowToJsonCast
extends SqlOperator {
    public static final RowToJsonCast ROW_TO_JSON = new RowToJsonCast();
    private static final Supplier<ObjectMapper> OBJECT_MAPPER = Suppliers.memoize(() -> new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer())));
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJson", Type.class, ConnectorSession.class, Block.class);

    private RowToJsonCast() {
        super(OperatorType.CAST, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.withVariadicBound("T", "row")), "json", (List<String>)ImmutableList.of((Object)"T"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = types.get("T");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(type);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    public static Slice toJson(Type rowType, ConnectorSession session, Block row) {
        ArrayList<Object> objectValue = new ArrayList<Object>(row.getPositionCount());
        for (int i = 0; i < row.getPositionCount(); ++i) {
            objectValue.add(((Type)rowType.getTypeParameters().get(i)).getObjectValue(session, row, i));
        }
        try {
            return Slices.utf8Slice((String)((ObjectMapper)OBJECT_MAPPER.get()).writeValueAsString(objectValue));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

