/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;

public class IdentityCast
extends SqlOperator {
    public static final IdentityCast IDENTITY_CAST = new IdentityCast();

    protected IdentityCast() {
        super(OperatorType.CAST, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("T")), "T", (List<String>)ImmutableList.of((Object)"T"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Expected only one type");
        Type type = types.get("T");
        MethodHandle identity = MethodHandles.identity(type.getJavaType());
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), identity, this.isDeterministic());
    }
}

