/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayIntersectFunction
extends SqlScalarFunction {
    public static final ArrayIntersectFunction ARRAY_INTERSECT_FUNCTION = new ArrayIntersectFunction();
    private static final String FUNCTION_NAME = "array_intersect";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayIntersectFunction.class, "intersect", Type.class, Block.class, Block.class);

    public ArrayIntersectFunction() {
        super(FUNCTION_NAME, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "array(E)", (List<String>)ImmutableList.of((Object)"array(E)", (Object)"array(E)"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Intersects elements of the two given arrays";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s expects only one argument", FUNCTION_NAME));
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(types.get("E"));
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), methodHandle, this.isDeterministic());
    }

    private static IntComparator IntBlockCompare(final Type type, final Block block) {
        return new AbstractIntComparator(){

            public int compare(int left, int right) {
                if (block.isNull(left) && block.isNull(right)) {
                    return 0;
                }
                if (block.isNull(left)) {
                    return -1;
                }
                if (block.isNull(right)) {
                    return 1;
                }
                return type.compareTo(block, left, block, right);
            }
        };
    }

    public static Block intersect(Type type, Block leftArray, Block rightArray) {
        int i;
        int leftPositionCount = leftArray.getPositionCount();
        int rightPositionCount = rightArray.getPositionCount();
        if (leftPositionCount == 0) {
            return leftArray;
        }
        if (rightPositionCount == 0) {
            return rightArray;
        }
        int[] leftPositions = new int[leftPositionCount];
        int[] rightPositions = new int[rightPositionCount];
        for (i = 0; i < leftPositionCount; ++i) {
            leftPositions[i] = i;
        }
        for (i = 0; i < rightPositionCount; ++i) {
            rightPositions[i] = i;
        }
        IntArrays.quickSort((int[])leftPositions, (IntComparator)ArrayIntersectFunction.IntBlockCompare(type, leftArray));
        IntArrays.quickSort((int[])rightPositions, (IntComparator)ArrayIntersectFunction.IntBlockCompare(type, rightArray));
        int entrySize = leftPositionCount < rightPositionCount ? (int)Math.ceil((double)leftArray.getSizeInBytes() / (double)leftPositionCount) : (int)Math.ceil((double)rightArray.getSizeInBytes() / (double)rightPositionCount);
        BlockBuilder resultBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), Math.min(leftArray.getPositionCount(), rightArray.getPositionCount()), entrySize);
        int leftCurrentPosition = 0;
        int rightCurrentPosition = 0;
        while (leftCurrentPosition < leftPositionCount && rightCurrentPosition < rightPositionCount) {
            int leftBasePosition = leftCurrentPosition;
            int rightBasePosition = rightCurrentPosition;
            int compareValue = type.compareTo(leftArray, leftPositions[leftCurrentPosition], rightArray, rightPositions[rightCurrentPosition]);
            if (compareValue > 0) {
                ++rightCurrentPosition;
                continue;
            }
            if (compareValue < 0) {
                ++leftCurrentPosition;
                continue;
            }
            type.appendTo(leftArray, leftPositions[leftCurrentPosition], resultBlockBuilder);
            ++leftCurrentPosition;
            ++rightCurrentPosition;
            while (leftCurrentPosition < leftPositionCount && type.equalTo(leftArray, leftPositions[leftBasePosition], leftArray, leftPositions[leftCurrentPosition])) {
                ++leftCurrentPosition;
            }
            while (rightCurrentPosition < rightPositionCount && type.equalTo(rightArray, rightPositions[rightBasePosition], rightArray, rightPositions[rightCurrentPosition])) {
                ++rightCurrentPosition;
            }
        }
        return resultBlockBuilder.build();
    }
}

