/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.OperatorDependency;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    private ArrayDistinctFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block distinct(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equals, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array) {
        if (array.getPositionCount() < 2) {
            return array;
        }
        if (array.getPositionCount() == 2) {
            if (type.equalTo(array, 0, array, 1)) {
                return array.getSingleValueBlock(0);
            }
            return array;
        }
        TypedSet typedSet = new TypedSet(type, array.getPositionCount());
        BlockBuilder distinctElementBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            type.appendTo(array, i, distinctElementBlockBuilder);
        }
        return distinctElementBlockBuilder.build();
    }

    @SqlType(value="array(bigint)")
    public static Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        boolean containsNull = false;
        LongOpenHashSet set = new LongOpenHashSet(array.getPositionCount());
        BlockBuilder distinctElementBlockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), array.getPositionCount());
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (!containsNull && array.isNull(i)) {
                containsNull = true;
                distinctElementBlockBuilder.appendNull();
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (!set.add(value)) continue;
            BigintType.BIGINT.writeLong(distinctElementBlockBuilder, value);
        }
        return distinctElementBlockBuilder.build();
    }
}

