/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.BlockComparator;
import com.facebook.presto.operator.aggregation.TypedKeyValueHeap;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.MinMaxByNState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;

public class MinMaxByNStateSerializer
implements AccumulatorStateSerializer<MinMaxByNState> {
    private final BlockComparator blockComparator;
    private final Type keyType;
    private final Type valueType;
    private final Type serializedType;

    public MinMaxByNStateSerializer(BlockComparator blockComparator, Type keyType, Type valueType) {
        this.blockComparator = blockComparator;
        this.keyType = keyType;
        this.valueType = valueType;
        this.serializedType = TypedKeyValueHeap.getSerializedType(keyType, valueType);
    }

    @Override
    public Type getSerializedType() {
        return this.serializedType;
    }

    @Override
    public void serialize(MinMaxByNState state, BlockBuilder out) {
        TypedKeyValueHeap heap = state.getTypedKeyValueHeap();
        if (heap == null) {
            out.appendNull();
            return;
        }
        heap.serialize(out);
    }

    @Override
    public void deserialize(Block block, int index, MinMaxByNState state) {
        if (block.isNull(index)) {
            return;
        }
        Block currentBlock = (Block)this.serializedType.getObject(block, index);
        state.setTypedKeyValueHeap(TypedKeyValueHeap.deserialize(currentBlock, this.keyType, this.valueType, this.blockComparator));
    }
}

