/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.TypedKeyValueHeap;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.MinMaxByNState;
import com.facebook.presto.util.array.ObjectBigArray;

public class MinMaxByNStateFactory
implements AccumulatorStateFactory<MinMaxByNState> {
    @Override
    public MinMaxByNState createSingleState() {
        return new SingleMinMaxByNState();
    }

    @Override
    public Class<? extends MinMaxByNState> getSingleStateClass() {
        return SingleMinMaxByNState.class;
    }

    @Override
    public MinMaxByNState createGroupedState() {
        return new GroupedMinMaxByNState();
    }

    @Override
    public Class<? extends MinMaxByNState> getGroupedStateClass() {
        return GroupedMinMaxByNState.class;
    }

    public static class SingleMinMaxByNState
    implements MinMaxByNState {
        private TypedKeyValueHeap typedKeyValueHeap;

        @Override
        public long getEstimatedSize() {
            if (this.typedKeyValueHeap == null) {
                return 0L;
            }
            return this.typedKeyValueHeap.getEstimatedSize();
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.typedKeyValueHeap;
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap typedKeyValueHeap) {
            this.typedKeyValueHeap = typedKeyValueHeap;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedMinMaxByNState
    extends AbstractGroupedAccumulatorState
    implements MinMaxByNState {
        private final ObjectBigArray<TypedKeyValueHeap> heaps = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.heaps.sizeOf() + this.size;
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.heaps.get(this.getGroupId());
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap value) {
            TypedKeyValueHeap previous = this.getTypedKeyValueHeap();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.heaps.set(this.getGroupId(), value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }
    }
}

