/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.RowType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class MaxOrMinByStateSerializer
implements AccumulatorStateSerializer<MaxOrMinByState> {
    private final Type valueType;
    private final Type keyType;
    private final Type serializedType;

    public MaxOrMinByStateSerializer(Type valueType, Type keyType) {
        this.valueType = valueType;
        this.keyType = keyType;
        this.serializedType = new RowType((List<Type>)ImmutableList.of((Object)keyType, (Object)valueType), Optional.empty());
    }

    @Override
    public Type getSerializedType() {
        return this.serializedType;
    }

    @Override
    public void serialize(MaxOrMinByState state, BlockBuilder out) {
        Block keyState = state.getKey();
        Block valueState = state.getValue();
        Preconditions.checkState((keyState == null == (valueState == null) ? 1 : 0) != 0, (Object)"(keyState == null) != (valueState == null)");
        if (keyState == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        this.keyType.appendTo(keyState, 0, blockBuilder);
        this.valueType.appendTo(valueState, 0, blockBuilder);
        out.closeEntry();
    }

    @Override
    public void deserialize(Block block, int index, MaxOrMinByState state) {
        if (block.isNull(index)) {
            state.setKey(null);
            state.setValue(null);
            return;
        }
        Block rowBlock = (Block)block.getObject(index, Block.class);
        state.setKey(rowBlock.getSingleValueBlock(0));
        state.setValue(rowBlock.getSingleValueBlock(1));
    }
}

