/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.CorrelationState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="corr")
public class CorrelationAggregation {
    private CorrelationAggregation() {
    }

    @InputFunction
    public static void input(CorrelationState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCorrelationState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(CorrelationState state, CorrelationState otherState) {
        AggregationUtils.mergeCorrelationState(state, otherState);
    }

    @OutputFunction(value="double")
    public static void corr(CorrelationState state, BlockBuilder out) {
        double divisor2;
        double result;
        double dividend = (double)state.getCount() * state.getSumXY() - state.getSumX() * state.getSumY();
        double divisor1 = (double)state.getCount() * state.getSumXSquare() - state.getSumX() * state.getSumX();
        if (Double.isFinite(result = (dividend *= dividend) / divisor1 / (divisor2 = (double)state.getCount() * state.getSumYSquare() - state.getSumY() * state.getSumY()))) {
            DoubleType.DOUBLE.writeDouble(out, Math.sqrt(result));
        } else {
            out.appendNull();
        }
    }
}

