/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileAggregations {
    public static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateLongPercentileAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateLongPercentileAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION_WITH_ACCURACY = new AggregationCompiler().generateAggregationFunction(ApproximateLongPercentileAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));

    private ApproximateLongPercentileAggregations() {
    }

    @InputFunction
    public static void input(DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="double") double percentile) {
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            digest = new QuantileDigest(0.01);
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        state.setPercentile(percentile);
    }

    @InputFunction
    public static void weightedInput(DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile) {
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            digest = new QuantileDigest(0.01);
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        state.setPercentile(percentile);
    }

    @InputFunction
    public static void weightedInput(DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            if (!(accuracy > 0.0) || !(accuracy < 1.0)) {
                throw new IllegalArgumentException("Percentile accuracy must be strictly between 0 and 1");
            }
            digest = new QuantileDigest(accuracy);
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        state.setPercentile(percentile);
    }

    @CombineFunction
    public static void combine(DigestAndPercentileState state, DigestAndPercentileState otherState) {
        QuantileDigest input = otherState.getDigest();
        QuantileDigest previous = state.getDigest();
        if (previous == null) {
            state.setDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
        state.setPercentile(otherState.getPercentile());
    }

    @OutputFunction(value="bigint")
    public static void output(DigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            BigintType.BIGINT.writeLong(out, digest.getQuantile(percentile));
        }
    }
}

