/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.BlockState;
import com.facebook.presto.operator.aggregation.state.BlockStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBooleanState;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.SliceState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractMinMaxAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle LONG_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableLongState.class, Long.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableDoubleState.class, Double.TYPE);
    private static final MethodHandle SLICE_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, SliceState.class, Slice.class);
    private static final MethodHandle BOOLEAN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableBooleanState.class, Boolean.TYPE);
    private static final MethodHandle BLOCK_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, BlockState.class, Block.class);
    private static final MethodHandle LONG_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle SLICE_OUTPUT_FUNCTION = Reflection.methodHandle(SliceState.class, "write", Type.class, SliceState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_OUTPUT_FUNCTION = Reflection.methodHandle(BlockState.class, "write", Type.class, BlockState.class, BlockBuilder.class);
    private final OperatorType operatorType;
    private final StateCompiler compiler = new StateCompiler();

    protected AbstractMinMaxAggregationFunction(String name, OperatorType operatorType) {
        super(name, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), "E", (List<String>)ImmutableList.of((Object)"E"));
        Objects.requireNonNull(operatorType);
        this.operatorType = operatorType;
    }

    @Override
    public InternalAggregationFunction specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        MethodHandle compareMethodHandle = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(this.operatorType, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        return this.generateAggregation(type, compareMethodHandle);
    }

    protected InternalAggregationFunction generateAggregation(Type type, MethodHandle compareMethodHandle) {
        MethodHandle outputFunction;
        MethodHandle inputFunction;
        AccumulatorStateSerializer<BlockState> stateSerializer;
        Class stateInterface;
        DynamicClassLoader classLoader = new DynamicClassLoader(AbstractMinMaxAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        if (type.getJavaType() == Long.TYPE) {
            stateInterface = NullableLongState.class;
            stateSerializer = this.compiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = LONG_INPUT_FUNCTION;
            outputFunction = LONG_OUTPUT_FUNCTION;
        } else if (type.getJavaType() == Double.TYPE) {
            stateInterface = NullableDoubleState.class;
            stateSerializer = this.compiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = DOUBLE_INPUT_FUNCTION;
            outputFunction = DOUBLE_OUTPUT_FUNCTION;
        } else if (type.getJavaType() == Slice.class) {
            stateInterface = SliceState.class;
            stateSerializer = this.compiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = SLICE_INPUT_FUNCTION;
            outputFunction = SLICE_OUTPUT_FUNCTION;
        } else if (type.getJavaType() == Boolean.TYPE) {
            stateInterface = NullableBooleanState.class;
            stateSerializer = this.compiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = BOOLEAN_INPUT_FUNCTION;
            outputFunction = BOOLEAN_OUTPUT_FUNCTION;
        } else {
            stateInterface = BlockState.class;
            stateSerializer = new BlockStateSerializer(type);
            inputFunction = BLOCK_INPUT_FUNCTION;
            outputFunction = BLOCK_OUTPUT_FUNCTION;
        }
        inputFunction = inputFunction.bindTo(compareMethodHandle);
        outputFunction = outputFunction.bindTo(type);
        AccumulatorStateFactory<NullableLongState> stateFactory = this.compiler.generateStateFactory(stateInterface, classLoader);
        Type intermediateType = stateSerializer.getSerializedType();
        List<AggregationMetadata.ParameterMetadata> inputParameterMetadata = AbstractMinMaxAggregationFunction.createInputParameterMetadata(type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getName(), type, (List<Type>)inputTypes), inputParameterMetadata, inputFunction, inputParameterMetadata, inputFunction, null, outputFunction, stateInterface, stateSerializer, stateFactory, type, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getName(), (List<Type>)inputTypes, intermediateType, type, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, type));
    }

    public static void input(MethodHandle methodHandle, NullableDoubleState state, double value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getDouble())) {
                state.setDouble(value);
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    public static void input(MethodHandle methodHandle, NullableLongState state, long value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getLong())) {
                state.setLong(value);
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    public static void input(MethodHandle methodHandle, SliceState state, Slice value) {
        if (state.getSlice() == null) {
            state.setSlice(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getSlice())) {
                state.setSlice(value);
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    public static void input(MethodHandle methodHandle, NullableBooleanState state, boolean value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getBoolean())) {
                state.setBoolean(value);
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }

    public static void input(MethodHandle methodHandle, BlockState state, Block value) {
        if (state.getBlock() == null) {
            state.setBlock(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getBlock())) {
                state.setBlock(value);
            }
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
        }
    }
}

