/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class SqlScalarFunction
implements SqlFunction {
    private final Signature signature;

    public static SqlScalarFunction create(Signature signature, String description, boolean hidden, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean deterministic, boolean nullable, List<Boolean> nullableArguments, Set<String> literalParameters) {
        return new SimpleSqlScalarFunction(signature, description, hidden, methodHandle, instanceFactory, deterministic, nullable, nullableArguments, literalParameters);
    }

    public SqlScalarFunction(String name, TypeSignature returnType, List<TypeSignature> argumentTypes, Set<String> literalParameters) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        this.signature = new Signature(name, FunctionKind.SCALAR, (List<TypeParameterRequirement>)ImmutableList.of(), returnType, (List<TypeSignature>)ImmutableList.copyOf(argumentTypes), false);
    }

    protected SqlScalarFunction(String name, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes) {
        this(name, typeParameterRequirements, returnType, argumentTypes, false, (Set<String>)ImmutableSet.of());
    }

    protected SqlScalarFunction(String name, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes, boolean variableArity) {
        this(name, typeParameterRequirements, returnType, argumentTypes, variableArity, (Set<String>)ImmutableSet.of());
    }

    protected SqlScalarFunction(String name, List<TypeParameterRequirement> typeParameterRequirements, String returnType, List<String> argumentTypes, boolean variableArity, Set<String> literalParameters) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeParameterRequirements, "typeParameters is null");
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Objects.requireNonNull(literalParameters, "literalParameters is null");
        this.signature = new Signature(name, FunctionKind.SCALAR, (List<TypeParameterRequirement>)ImmutableList.copyOf(typeParameterRequirements), returnType, (List<String>)ImmutableList.copyOf(argumentTypes), variableArity, literalParameters);
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    public abstract ScalarFunctionImplementation specialize(Map<String, Type> var1, int var2, TypeManager var3, FunctionRegistry var4);

    private static class SimpleSqlScalarFunction
    extends SqlScalarFunction {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> instanceFactory;
        private final String description;
        private final boolean hidden;
        private final boolean nullable;
        private final List<Boolean> nullableArguments;
        private final boolean deterministic;

        public SimpleSqlScalarFunction(Signature signature, String description, boolean hidden, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean deterministic, boolean nullable, List<Boolean> nullableArguments, Set<String> literalParameters) {
            super(signature.getName(), (List<TypeParameterRequirement>)ImmutableList.of(), signature.getReturnType().toString(), (List)signature.getArgumentTypes().stream().map(TypeSignature::toString).collect(ImmutableCollectors.toImmutableList()), false, literalParameters);
            Preconditions.checkArgument((boolean)signature.getTypeParameterRequirements().isEmpty(), (String)"%s is parametric", (Object[])new Object[]{signature});
            this.description = description;
            this.hidden = hidden;
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            this.deterministic = deterministic;
            this.nullable = nullable;
            this.nullableArguments = Objects.requireNonNull(nullableArguments, "nullableArguments is null");
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isDeterministic() {
            return this.deterministic;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return new ScalarFunctionImplementation(this.nullable, this.nullableArguments, this.methodHandle, this.instanceFactory, this.isDeterministic());
        }
    }
}

