/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.informationSchema.InformationSchemaHandleResolver;
import com.facebook.presto.connector.system.SystemHandleResolver;
import com.facebook.presto.metadata.RemoteHandleResolver;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;

public class HandleResolver {
    private final ConcurrentMap<String, ConnectorHandleResolver> handleResolvers = new ConcurrentHashMap<String, ConnectorHandleResolver>();

    @Inject
    public HandleResolver() {
        this.handleResolvers.put("remote", new RemoteHandleResolver());
        this.handleResolvers.put("$system", new SystemHandleResolver());
        this.handleResolvers.put("$info_schema", new InformationSchemaHandleResolver());
    }

    public void addConnectorName(String name, ConnectorHandleResolver resolver) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(resolver, "resolver is null");
        ConnectorHandleResolver existingResolver = this.handleResolvers.putIfAbsent(name, resolver);
        Preconditions.checkState((existingResolver == null || existingResolver.equals(resolver) ? 1 : 0) != 0, (String)"Connector '%s' is already assigned to resolver: %s", (Object[])new Object[]{name, existingResolver});
    }

    public String getId(ConnectorTableHandle tableHandle) {
        return this.getId(tableHandle, ConnectorHandleResolver::getTableHandleClass);
    }

    public String getId(ConnectorTableLayoutHandle handle) {
        return this.getId(handle, ConnectorHandleResolver::getTableLayoutHandleClass);
    }

    public String getId(ColumnHandle columnHandle) {
        return this.getId(columnHandle, ConnectorHandleResolver::getColumnHandleClass);
    }

    public String getId(ConnectorSplit split) {
        return this.getId(split, ConnectorHandleResolver::getSplitClass);
    }

    public String getId(ConnectorIndexHandle indexHandle) {
        return this.getId(indexHandle, ConnectorHandleResolver::getIndexHandleClass);
    }

    public String getId(ConnectorOutputTableHandle outputHandle) {
        return this.getId(outputHandle, ConnectorHandleResolver::getOutputTableHandleClass);
    }

    public String getId(ConnectorInsertTableHandle insertHandle) {
        return this.getId(insertHandle, ConnectorHandleResolver::getInsertTableHandleClass);
    }

    public String getId(ConnectorPartitioningHandle partitioningHandle) {
        return this.getId(partitioningHandle, ConnectorHandleResolver::getPartitioningHandleClass);
    }

    public String getId(ConnectorTransactionHandle transactionHandle) {
        return this.getId(transactionHandle, ConnectorHandleResolver::getTransactionHandleClass);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass(String id) {
        return this.resolverFor(id).getTableHandleClass();
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass(String id) {
        return this.resolverFor(id).getTableLayoutHandleClass();
    }

    public Class<? extends ColumnHandle> getColumnHandleClass(String id) {
        return this.resolverFor(id).getColumnHandleClass();
    }

    public Class<? extends ConnectorSplit> getSplitClass(String id) {
        return this.resolverFor(id).getSplitClass();
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass(String id) {
        return this.resolverFor(id).getIndexHandleClass();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass(String id) {
        return this.resolverFor(id).getOutputTableHandleClass();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass(String id) {
        return this.resolverFor(id).getInsertTableHandleClass();
    }

    public Class<? extends ConnectorPartitioningHandle> getPartitioningHandleClass(String id) {
        return this.resolverFor(id).getPartitioningHandleClass();
    }

    public Class<? extends ConnectorTransactionHandle> getTransactionHandleClass(String id) {
        return this.resolverFor(id).getTransactionHandleClass();
    }

    public ConnectorHandleResolver resolverFor(String id) {
        ConnectorHandleResolver resolver = (ConnectorHandleResolver)this.handleResolvers.get(id);
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"No handle resolver for connector: %s", (Object[])new Object[]{id});
        return resolver;
    }

    private <T> String getId(T handle, Function<ConnectorHandleResolver, Class<? extends T>> getter) {
        for (Map.Entry entry : this.handleResolvers.entrySet()) {
            try {
                if (!getter.apply((ConnectorHandleResolver)entry.getValue()).isInstance(handle)) continue;
                return (String)entry.getKey();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        throw new IllegalArgumentException("No connector for handle: " + handle);
    }
}

