/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.GenericAggregationFunctionFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.ReflectionParametricScalar;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.SqlWindowFunction;
import com.facebook.presto.operator.window.ValueWindowFunction;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.LiteralParameters;
import com.facebook.presto.type.SqlType;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.joni.Regex;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class FunctionListBuilder {
    private static final Set<Class<?>> NON_NULLABLE_ARGUMENT_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Boolean.TYPE, Regex.class, JsonPath.class);
    private final List<SqlFunction> functions = new ArrayList<SqlFunction>();
    private final TypeManager typeManager;

    public FunctionListBuilder(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public FunctionListBuilder window(String name, Type returnType, List<? extends Type> argumentTypes, Class<? extends WindowFunction> functionClass) {
        ReflectionWindowFunctionSupplier<? extends WindowFunction> windowFunctionSupplier = new ReflectionWindowFunctionSupplier<WindowFunction>(new Signature(name, FunctionKind.WINDOW, returnType.getTypeSignature(), Lists.transform((List)ImmutableList.copyOf(argumentTypes), Type::getTypeSignature)), functionClass);
        this.functions.add(new SqlWindowFunction(windowFunctionSupplier));
        return this;
    }

    public FunctionListBuilder window(String name, Class<? extends ValueWindowFunction> clazz, String typeVariable, String ... argumentTypes) {
        Signature signature = new Signature(name, FunctionKind.WINDOW, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter(typeVariable)), typeVariable, (List<String>)ImmutableList.copyOf((Object[])argumentTypes), false, (Set<String>)ImmutableSet.of());
        this.functions.add(new SqlWindowFunction(new ReflectionWindowFunctionSupplier<ValueWindowFunction>(signature, clazz)));
        return this;
    }

    public FunctionListBuilder aggregate(List<InternalAggregationFunction> functions) {
        for (InternalAggregationFunction function : functions) {
            this.aggregate(function);
        }
        return this;
    }

    public FunctionListBuilder aggregate(InternalAggregationFunction function) {
        String name = function.name();
        name = name.toLowerCase(Locale.ENGLISH);
        String description = FunctionListBuilder.getDescription(function.getClass());
        this.functions.add(SqlAggregationFunction.create(name, description, function));
        return this;
    }

    public FunctionListBuilder aggregate(Class<?> aggregationDefinition) {
        this.functions.addAll(GenericAggregationFunctionFactory.fromAggregationDefinition(aggregationDefinition, this.typeManager).listFunctions());
        return this;
    }

    public FunctionListBuilder scalar(Signature signature, MethodHandle function, Optional<MethodHandle> instanceFactory, boolean deterministic, String description, boolean hidden, boolean nullable, List<Boolean> nullableArguments, Set<String> literalParameters) {
        this.functions.add(SqlScalarFunction.create(signature, description, hidden, function, instanceFactory, deterministic, nullable, nullableArguments, literalParameters));
        return this;
    }

    private FunctionListBuilder operator(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes, MethodHandle function, Optional<MethodHandle> instanceFactory, boolean nullable, List<Boolean> nullableArguments, Set<String> literalParameters) {
        operatorType.validateSignature(returnType, argumentTypes);
        this.functions.add(SqlOperator.create(operatorType, argumentTypes, returnType, function, instanceFactory, nullable, nullableArguments, literalParameters));
        return this;
    }

    public FunctionListBuilder scalar(Class<?> clazz) {
        ScalarFunction scalarAnnotation = clazz.getAnnotation(ScalarFunction.class);
        ScalarOperator operatorAnnotation = clazz.getAnnotation(ScalarOperator.class);
        if (scalarAnnotation != null || operatorAnnotation != null) {
            this.functions.add(ReflectionParametricScalar.parseDefinition(clazz));
            return this;
        }
        try {
            boolean foundOne = false;
            for (Method method : clazz.getMethods()) {
                foundOne = this.processScalarFunction(method) || foundOne;
                foundOne = this.processScalarOperator(method) || foundOne;
            }
            Preconditions.checkArgument((boolean)foundOne, (String)"Expected class %s to be annotated with @%s, or contain at least one method annotated with @%s", (Object[])new Object[]{clazz.getName(), ScalarFunction.class.getSimpleName(), ScalarFunction.class.getSimpleName()});
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public FunctionListBuilder functions(SqlFunction ... sqlFunctions) {
        for (SqlFunction sqlFunction : sqlFunctions) {
            this.function(sqlFunction);
        }
        return this;
    }

    public FunctionListBuilder function(SqlFunction sqlFunction) {
        Objects.requireNonNull(sqlFunction, "parametricFunction is null");
        this.functions.add(sqlFunction);
        return this;
    }

    private boolean processScalarFunction(Method method) throws IllegalAccessException {
        SqlType returnTypeAnnotation;
        ScalarFunction scalarFunction = method.getAnnotation(ScalarFunction.class);
        if (scalarFunction == null) {
            return false;
        }
        FunctionListBuilder.checkValidMethod(method);
        Optional<MethodHandle> instanceFactory = FunctionListBuilder.getInstanceFactory(method);
        MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
        String name = scalarFunction.value();
        if (name.isEmpty()) {
            name = FunctionListBuilder.camelToSnake(method.getName());
        }
        Preconditions.checkArgument(((returnTypeAnnotation = method.getAnnotation(SqlType.class)) != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
        LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
        ImmutableSet literalParameters = ImmutableSet.of();
        if (literalParametersAnnotation != null) {
            literalParameters = ImmutableSet.copyOf((Object[])literalParametersAnnotation.value());
        }
        Signature signature = new Signature(name.toLowerCase(Locale.ENGLISH), FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)returnTypeAnnotation.value(), (Set)literalParameters), FunctionListBuilder.parameterTypeSignatures(method, (Set<String>)literalParameters));
        FunctionListBuilder.verifyMethodSignature(method, signature.getReturnType(), signature.getArgumentTypes(), this.typeManager);
        List<Boolean> nullableArguments = FunctionListBuilder.getNullableArguments(method);
        this.scalar(signature, methodHandle, instanceFactory, scalarFunction.deterministic(), FunctionListBuilder.getDescription(method), scalarFunction.hidden(), method.isAnnotationPresent(Nullable.class), nullableArguments, (Set<String>)literalParameters);
        for (String alias : scalarFunction.alias()) {
            this.scalar(signature.withAlias(alias.toLowerCase(Locale.ENGLISH)), methodHandle, instanceFactory, scalarFunction.deterministic(), FunctionListBuilder.getDescription(method), scalarFunction.hidden(), method.isAnnotationPresent(Nullable.class), nullableArguments, (Set<String>)literalParameters);
        }
        return true;
    }

    private static Optional<MethodHandle> getInstanceFactory(Method method) throws IllegalAccessException {
        Optional<MethodHandle> instanceFactory = Optional.empty();
        if (!Modifier.isStatic(method.getModifiers())) {
            try {
                instanceFactory = Optional.of(MethodHandles.lookup().unreflectConstructor(method.getDeclaringClass().getConstructor(new Class[0])));
            }
            catch (NoSuchMethodException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("%s is non-static, but its declaring class is missing a default constructor", method));
            }
        }
        return instanceFactory;
    }

    private static Type type(TypeManager typeManager, SqlType explicitType) {
        Type type = typeManager.getType(TypeSignature.parseTypeSignature((String)explicitType.value()));
        Objects.requireNonNull(type, String.format("No type found for '%s'", explicitType.value()));
        return type;
    }

    private static List<TypeSignature> parameterTypeSignatures(Method method, Set<String> literalParameters) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ImmutableList.Builder types = ImmutableList.builder();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> clazz = method.getParameterTypes()[i];
            if (clazz == ConnectorSession.class) continue;
            SqlType explicitType = null;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof SqlType)) continue;
                explicitType = (SqlType)annotation;
                break;
            }
            Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s argument %s does not have a @SqlType annotation", (Object[])new Object[]{method, i});
            types.add((Object)TypeSignature.parseTypeSignature((String)explicitType.value(), literalParameters));
        }
        return types.build();
    }

    private static void verifyMethodSignature(Method method, TypeSignature returnTypeName, List<TypeSignature> argumentTypeNames, TypeManager typeManager) {
        if (!returnTypeName.isCalculated()) {
            Type returnType = typeManager.getType(returnTypeName);
            Objects.requireNonNull(returnType, "returnType is null");
            Preconditions.checkArgument((Primitives.unwrap(method.getReturnType()) == returnType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s return type to be %s (%s)", (Object[])new Object[]{method, returnType.getJavaType().getName(), returnType});
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        if (parameterTypes.length > 0 && parameterTypes[0] == ConnectorSession.class) {
            parameterTypes = Arrays.copyOfRange(parameterTypes, 1, parameterTypes.length);
            annotations = (Annotation[][])Arrays.copyOfRange(annotations, 1, annotations.length);
        }
        for (int i = 0; i < argumentTypeNames.size(); ++i) {
            TypeSignature expectedTypeName = argumentTypeNames.get(i);
            if (expectedTypeName.isCalculated()) continue;
            Type expectedType = typeManager.getType(expectedTypeName);
            Class<?> actualType = parameterTypes[i];
            boolean nullable = Arrays.asList(annotations[i]).stream().anyMatch(Nullable.class::isInstance);
            if (Primitives.isWrapperType(actualType)) {
                Preconditions.checkArgument((boolean)nullable, (String)"Method %s has parameter with type %s that is missing @Nullable", (Object[])new Object[]{method, actualType});
            }
            if (nullable) {
                Preconditions.checkArgument((!NON_NULLABLE_ARGUMENT_TYPES.contains(actualType) ? 1 : 0) != 0, (String)"Method %s has parameter type %s, but @Nullable is not supported on this type", (Object[])new Object[]{method, actualType});
            }
            Preconditions.checkArgument((Primitives.unwrap(actualType) == expectedType.getJavaType() ? 1 : 0) != 0, (String)"Expected method %s parameter %s type to be %s (%s)", (Object[])new Object[]{method, i, expectedType.getJavaType().getName(), expectedType});
        }
    }

    private static List<Boolean> getNullableArguments(Method method) {
        ArrayList<Boolean> nullableArguments = new ArrayList<Boolean>();
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            boolean nullable = false;
            boolean foundSqlType = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Nullable) {
                    nullable = true;
                }
                if (!(annotation instanceof SqlType)) continue;
                foundSqlType = true;
            }
            if (!foundSqlType) continue;
            nullableArguments.add(nullable);
        }
        return nullableArguments;
    }

    private boolean processScalarOperator(Method method) throws IllegalAccessException {
        TypeSignature returnTypeSignature;
        ScalarOperator scalarOperator = method.getAnnotation(ScalarOperator.class);
        if (scalarOperator == null) {
            return false;
        }
        FunctionListBuilder.checkValidMethod(method);
        Optional<MethodHandle> instanceFactory = FunctionListBuilder.getInstanceFactory(method);
        MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
        OperatorType operatorType = scalarOperator.value();
        LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
        ImmutableSet literalParameters = ImmutableSet.of();
        if (literalParametersAnnotation != null) {
            literalParameters = ImmutableSet.copyOf((Object[])literalParametersAnnotation.value());
        }
        List<TypeSignature> argumentTypes = FunctionListBuilder.parameterTypeSignatures(method, (Set<String>)literalParameters);
        if (operatorType == OperatorType.HASH_CODE) {
            returnTypeSignature = BigintType.BIGINT.getTypeSignature();
        } else {
            SqlType explicitType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((explicitType != null ? 1 : 0) != 0, (String)"Method %s return type does not have a @SqlType annotation", (Object[])new Object[]{method});
            returnTypeSignature = TypeSignature.parseTypeSignature((String)explicitType.value(), (Set)literalParameters);
            FunctionListBuilder.verifyMethodSignature(method, returnTypeSignature, argumentTypes, this.typeManager);
        }
        List<Boolean> nullableArguments = FunctionListBuilder.getNullableArguments(method);
        this.operator(operatorType, returnTypeSignature, argumentTypes, methodHandle, instanceFactory, method.isAnnotationPresent(Nullable.class), nullableArguments, (Set<String>)literalParameters);
        return true;
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }

    private static String camelToSnake(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    private static void checkValidMethod(Method method) {
        String message = "@ScalarFunction method %s is not valid: ";
        if (method.getAnnotation(Nullable.class) != null) {
            Preconditions.checkArgument((!method.getReturnType().isPrimitive() ? 1 : 0) != 0, (String)(message + "annotated with @Nullable but has primitive return type"), (Object[])new Object[]{method});
        } else {
            Preconditions.checkArgument((!Primitives.isWrapperType(method.getReturnType()) ? 1 : 0) != 0, (String)"not annotated with @Nullable but has boxed primitive return type", (Object[])new Object[]{method});
        }
    }

    public List<SqlFunction> getFunctions() {
        return ImmutableList.copyOf(this.functions);
    }
}

