/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.execution.QueryId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class MemoryPoolInfo {
    private final long maxBytes;
    private final long freeBytes;
    private final Map<QueryId, Long> queryMemoryReservations;

    @JsonCreator
    public MemoryPoolInfo(@JsonProperty(value="maxBytes") long maxBytes, @JsonProperty(value="freeBytes") long freeBytes, @JsonProperty(value="queryMemoryReservations") Map<QueryId, Long> queryMemoryReservations) {
        this.maxBytes = maxBytes;
        this.freeBytes = freeBytes;
        this.queryMemoryReservations = ImmutableMap.copyOf(queryMemoryReservations);
    }

    @JsonProperty
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @JsonProperty
    public long getFreeBytes() {
        return this.freeBytes;
    }

    @JsonProperty
    public Map<QueryId, Long> getQueryMemoryReservations() {
        return this.queryMemoryReservations;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxBytes", this.maxBytes).add("freeBytes", this.freeBytes).toString();
    }
}

