/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.index;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.connector.ConnectorIndexProvider;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IndexManager {
    private final ConcurrentMap<String, ConnectorIndexProvider> providers = new ConcurrentHashMap<String, ConnectorIndexProvider>();

    public void addIndexProvider(String connectorId, ConnectorIndexProvider provider) {
        Preconditions.checkState((this.providers.putIfAbsent(connectorId, provider) == null ? 1 : 0) != 0, (String)"IndexProvider for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public ConnectorIndex getIndex(Session session, IndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        ConnectorSession connectorSession = session.toConnectorSession(indexHandle.getConnectorId());
        ConnectorIndexProvider provider = this.getProvider(indexHandle);
        return provider.getIndex(indexHandle.getTransactionHandle(), connectorSession, indexHandle.getConnectorHandle(), lookupSchema, outputSchema);
    }

    private ConnectorIndexProvider getProvider(IndexHandle handle) {
        ConnectorIndexProvider result = (ConnectorIndexProvider)this.providers.get(handle.getConnectorId());
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No index provider for connector '%s'", (Object[])new Object[]{handle.getConnectorId()});
        return result;
    }
}

