/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.NodeSelector;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.SourcePartitionedScheduler;
import com.facebook.presto.execution.scheduler.SplitPlacementPolicy;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.Node;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.NodePartitionMap;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class FixedSourcePartitionedScheduler
implements StageScheduler {
    private final SqlStageExecution stage;
    private final NodePartitionMap partitioning;
    private final SourcePartitionedScheduler sourcePartitionedScheduler;
    private boolean scheduledTasks;

    public FixedSourcePartitionedScheduler(SqlStageExecution stage, SplitSource splitSource, NodePartitionMap partitioning, int splitBatchSize, NodeSelector nodeSelector) {
        Objects.requireNonNull(stage, "stage is null");
        Objects.requireNonNull(splitSource, "splitSource is null");
        Objects.requireNonNull(partitioning, "partitioning is null");
        this.stage = stage;
        this.partitioning = partitioning;
        FixedSplitPlacementPolicy splitPlacementPolicy = new FixedSplitPlacementPolicy(nodeSelector, partitioning, stage::getAllTasks);
        this.sourcePartitionedScheduler = new SourcePartitionedScheduler(stage, splitSource, splitPlacementPolicy, splitBatchSize);
    }

    @Override
    public ScheduleResult schedule() {
        Object newTasks = ImmutableList.of();
        if (!this.scheduledTasks) {
            newTasks = (List)this.partitioning.getPartitionToNode().entrySet().stream().map(entry -> this.stage.scheduleTask((Node)entry.getValue(), (Integer)entry.getKey())).collect(ImmutableCollectors.toImmutableList());
            this.scheduledTasks = true;
        }
        ScheduleResult schedule = this.sourcePartitionedScheduler.schedule();
        return new ScheduleResult(schedule.isFinished(), (Iterable<? extends RemoteTask>)newTasks, schedule.getBlocked());
    }

    @Override
    public void close() {
        this.sourcePartitionedScheduler.close();
    }

    private static class FixedSplitPlacementPolicy
    implements SplitPlacementPolicy {
        private final NodeSelector nodeSelector;
        private final NodePartitionMap partitioning;
        private final Supplier<? extends List<RemoteTask>> remoteTasks;

        public FixedSplitPlacementPolicy(NodeSelector nodeSelector, NodePartitionMap partitioning, Supplier<? extends List<RemoteTask>> remoteTasks) {
            this.nodeSelector = nodeSelector;
            this.partitioning = partitioning;
            this.remoteTasks = remoteTasks;
        }

        @Override
        public Multimap<Node, Split> computeAssignments(Set<Split> splits) {
            return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get(), this.partitioning);
        }

        @Override
        public void lockDownNodes() {
        }

        @Override
        public List<Node> allNodes() {
            return ImmutableList.copyOf(this.partitioning.getPartitionToNode().values());
        }
    }
}

