/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BufferResult {
    private final String taskInstanceId;
    private final long token;
    private final long nextToken;
    private final boolean bufferComplete;
    private final List<Page> pages;

    public static BufferResult emptyResults(String taskInstanceId, long token, boolean bufferComplete) {
        return new BufferResult(taskInstanceId, token, token, bufferComplete, (List<Page>)ImmutableList.of());
    }

    public BufferResult(String taskInstanceId, long token, long nextToken, boolean bufferComplete, List<Page> pages) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)taskInstanceId) ? 1 : 0) != 0, (Object)"taskInstanceId is null");
        this.taskInstanceId = taskInstanceId;
        this.token = token;
        this.nextToken = nextToken;
        this.bufferComplete = bufferComplete;
        this.pages = ImmutableList.copyOf((Collection)Objects.requireNonNull(pages, "pages is null"));
    }

    public long getToken() {
        return this.token;
    }

    public long getNextToken() {
        return this.nextToken;
    }

    public boolean isBufferComplete() {
        return this.bufferComplete;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public int size() {
        return this.pages.size();
    }

    public boolean isEmpty() {
        return this.pages.isEmpty();
    }

    public String getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferResult that = (BufferResult)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.nextToken, that.nextToken) && Objects.equals(this.taskInstanceId, that.taskInstanceId) && Objects.equals(this.bufferComplete, that.bufferComplete) && Objects.equals(this.pages, that.pages);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.nextToken, this.taskInstanceId, this.bufferComplete, this.pages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("taskInstanceId", (Object)this.taskInstanceId).add("bufferComplete", this.bufferComplete).add("pages", this.pages).toString();
    }
}

