/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.event.query;

import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.event.query.QueryCompletionEvent;
import com.facebook.presto.event.query.QueryCreatedEvent;
import com.facebook.presto.event.query.SplitCompletionEvent;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.transaction.TransactionId;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.event.client.EventClient;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QueryMonitor {
    private static final Logger log = Logger.get(QueryMonitor.class);
    private final ObjectMapper objectMapper;
    private final EventClient eventClient;
    private final String environment;
    private final String serverVersion;

    @Inject
    public QueryMonitor(ObjectMapper objectMapper, EventClient eventClient, NodeInfo nodeInfo, NodeVersion nodeVersion) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.serverVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null").toString();
    }

    public void createdEvent(QueryInfo queryInfo) {
        this.eventClient.post((Object[])new QueryCreatedEvent[]{new QueryCreatedEvent(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(null), queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal().orElse(null), queryInfo.getSession().getSource().orElse(null), this.serverVersion, this.environment, queryInfo.getSession().getCatalog().orElse(null), queryInfo.getSession().getSchema().orElse(null), queryInfo.getSession().getRemoteUserAddress().orElse(null), queryInfo.getSession().getUserAgent().orElse(null), queryInfo.getSelf(), queryInfo.getQuery(), queryInfo.getQueryStats().getCreateTime())});
    }

    public void completionEvent(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            FailureInfo failureInfo = queryInfo.getFailureInfo();
            String failureType = failureInfo == null ? null : failureInfo.getType();
            String failureMessage = failureInfo == null ? null : failureInfo.getMessage();
            ImmutableMap.Builder mergedProperties = ImmutableMap.builder();
            mergedProperties.putAll(queryInfo.getSession().getSystemProperties());
            for (Map.Entry<String, Map<String, String>> catalogEntry : queryInfo.getSession().getCatalogProperties().entrySet()) {
                for (Map.Entry<String, String> entry : catalogEntry.getValue().entrySet()) {
                    mergedProperties.put((Object)(catalogEntry.getKey() + "." + entry.getKey()), (Object)entry.getValue());
                }
            }
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(queryInfo.getOutputStage());
            String failureHost = task.map(x -> x.getSelf().getHost()).orElse(null);
            String failureTask = task.map(x -> x.getTaskId().toString()).orElse(null);
            this.eventClient.post((Object[])new QueryCompletionEvent[]{new QueryCompletionEvent(queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(null), queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal().orElse(null), queryInfo.getSession().getSource().orElse(null), this.serverVersion, this.environment, queryInfo.getSession().getCatalog().orElse(null), queryInfo.getSession().getSchema().orElse(null), queryInfo.getSession().getRemoteUserAddress().orElse(null), queryInfo.getSession().getUserAgent().orElse(null), queryInfo.getState(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryStats.getPeakMemoryReservation().toBytes(), queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getEndTime(), queryStats.getQueuedTime(), queryStats.getAnalysisTime(), queryStats.getDistributedPlanningTime(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getTotalDrivers(), queryInfo.getErrorCode(), failureType, failureMessage, failureTask, failureHost, this.objectMapper.writeValueAsString((Object)queryInfo.getOutputStage()), this.objectMapper.writeValueAsString((Object)queryInfo.getFailureInfo()), this.objectMapper.writeValueAsString(queryInfo.getInputs()), this.objectMapper.writeValueAsString((Object)mergedProperties.build()))});
            this.logQueryTimeline(queryInfo);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Optional<TaskInfo> findFailedTask(StageInfo stageInfo) {
        for (StageInfo subStage : stageInfo.getSubStages()) {
            Optional<TaskInfo> task = QueryMonitor.findFailedTask(subStage);
            if (!task.isPresent()) continue;
            return task;
        }
        return stageInfo.getTasks().stream().filter(taskInfo -> taskInfo.getState() == TaskState.FAILED).findFirst();
    }

    private void logQueryTimeline(QueryInfo queryInfo) {
        try {
            QueryStats queryStats = queryInfo.getQueryStats();
            DateTime queryStartTime = queryStats.getCreateTime();
            DateTime queryEndTime = queryStats.getEndTime();
            if (queryStartTime == null || queryEndTime == null) {
                return;
            }
            Duration planning = queryStats.getTotalPlanningTime();
            if (planning == null) {
                planning = new Duration(0.0, TimeUnit.MILLISECONDS);
            }
            List<StageInfo> stages = StageInfo.getAllStages(queryInfo.getOutputStage());
            long firstTaskStartTime = queryEndTime.getMillis();
            long lastTaskStartTime = queryStartTime.getMillis() + planning.toMillis();
            long lastTaskEndTime = queryStartTime.getMillis() + planning.toMillis();
            for (StageInfo stage : stages) {
                if (!stage.getSubStages().isEmpty()) continue;
                for (TaskInfo taskInfo : stage.getTasks()) {
                    DateTime endTime;
                    DateTime lastStartTime;
                    TaskStats taskStats = taskInfo.getStats();
                    DateTime firstStartTime = taskStats.getFirstStartTime();
                    if (firstStartTime != null) {
                        firstTaskStartTime = Math.min(firstStartTime.getMillis(), firstTaskStartTime);
                    }
                    if ((lastStartTime = taskStats.getLastStartTime()) != null) {
                        lastTaskStartTime = Math.max(lastStartTime.getMillis(), lastTaskStartTime);
                    }
                    if ((endTime = taskStats.getEndTime()) == null) continue;
                    lastTaskEndTime = Math.max(endTime.getMillis(), lastTaskEndTime);
                }
            }
            Duration elapsed = QueryMonitor.millis(queryEndTime.getMillis() - queryStartTime.getMillis());
            Duration scheduling = QueryMonitor.millis(firstTaskStartTime - queryStartTime.getMillis() - planning.toMillis());
            Duration running = QueryMonitor.millis(lastTaskEndTime - firstTaskStartTime);
            Duration finishing = QueryMonitor.millis(queryEndTime.getMillis() - lastTaskEndTime);
            log.info("TIMELINE: Query %s :: Transaction:[%s] :: elapsed %s :: planning %s :: scheduling %s :: running %s :: finishing %s :: begin %s :: end %s", new Object[]{queryInfo.getQueryId(), queryInfo.getSession().getTransactionId().map(TransactionId::toString).orElse(""), elapsed, planning, scheduling, running, finishing, queryStartTime, queryEndTime});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error logging query timeline");
        }
    }

    public void splitCompletionEvent(TaskId taskId, DriverStats driverStats) {
        this.splitCompletionEvent(taskId, driverStats, null, null);
    }

    public void splitFailedEvent(TaskId taskId, DriverStats driverStats, Throwable cause) {
        this.splitCompletionEvent(taskId, driverStats, cause.getClass().getName(), cause.getMessage());
    }

    private void splitCompletionEvent(TaskId taskId, DriverStats driverStats, @Nullable String failureType, @Nullable String failureMessage) {
        Duration timeToStart = null;
        if (driverStats.getStartTime() != null) {
            timeToStart = QueryMonitor.millis(driverStats.getStartTime().getMillis() - driverStats.getCreateTime().getMillis());
        }
        Duration timeToEnd = null;
        if (driverStats.getEndTime() != null) {
            timeToEnd = QueryMonitor.millis(driverStats.getEndTime().getMillis() - driverStats.getCreateTime().getMillis());
        }
        try {
            this.eventClient.post((Object[])new SplitCompletionEvent[]{new SplitCompletionEvent(taskId.getQueryId(), taskId.getStageId(), taskId, this.environment, driverStats.getQueuedTime(), driverStats.getStartTime(), timeToStart, timeToEnd, driverStats.getRawInputDataSize(), driverStats.getRawInputPositions(), driverStats.getRawInputReadTime(), driverStats.getElapsedTime(), driverStats.getTotalCpuTime(), driverStats.getTotalUserTime(), failureType, failureMessage, this.objectMapper.writeValueAsString((Object)driverStats))});
        }
        catch (JsonProcessingException e) {
            log.error((Throwable)e, "Error posting split completion event for task %s", new Object[]{taskId});
        }
    }

    private static Duration millis(long millis) {
        if (millis < 0L) {
            millis = 0L;
        }
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }
}

