/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.scalar.RowFieldReference;
import com.facebook.presto.spi.type.NamedType;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    @Override
    public String getName() {
        return "row";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"Row type must have at least one parameter");
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE_SIGNATURE), (String)"Expected only named types as a parameters, got %s", (Object[])new Object[]{parameters});
        List namedTypes = parameters.stream().map(TypeParameter::getNamedType).collect(Collectors.toList());
        return new RowType(namedTypes.stream().map(NamedType::getType).collect(Collectors.toList()), Optional.of(namedTypes.stream().map(NamedType::getName).collect(Collectors.toList())));
    }

    public List<SqlFunction> createFunctions(Type type) {
        RowType rowType = Types.checkType(type, RowType.class, "type");
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RowType.RowField> fields = rowType.getFields();
        int i = 0;
        while (i < fields.size()) {
            RowType.RowField field = fields.get(i);
            int index = i++;
            field.getName().ifPresent(name -> builder.add((Object)new RowFieldReference(rowType, field.getType(), index, field.getName().get())));
        }
        return builder.build();
    }
}

