/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.type.FunctionType;
import com.facebook.presto.type.ParametricType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public final class FunctionParametricType
implements ParametricType {
    public static final FunctionParametricType FUNCTION = new FunctionParametricType();

    private FunctionParametricType() {
    }

    @Override
    public String getName() {
        return "function";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() >= 1 ? 1 : 0) != 0, (String)"Function type must have at least one parameter, got %s", (Object[])new Object[]{parameters});
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.TYPE_SIGNATURE), (String)"Expected only types as a parameters, got %s", (Object[])new Object[]{parameters});
        List types = parameters.stream().map(parameter -> parameter.getType()).collect(Collectors.toList());
        return new FunctionType(types.subList(0, types.size() - 1), (Type)types.get(types.size() - 1));
    }
}

