/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;

public class ChildReplacer
extends PlanVisitor<List<PlanNode>, PlanNode> {
    private static final ChildReplacer INSTANCE = new ChildReplacer();

    public static PlanNode replaceChildren(PlanNode node, List<PlanNode> children) {
        for (int i = 0; i < node.getSources().size(); ++i) {
            if (children.get(i) == node.getSources().get(i)) continue;
            return node.accept(INSTANCE, children);
        }
        return node;
    }

    @Override
    public PlanNode visitPlan(PlanNode node, List<PlanNode> newChildren) {
        throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
    }

    @Override
    public PlanNode visitLimit(LimitNode node, List<PlanNode> newChildren) {
        return new LimitNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getCount());
    }

    @Override
    public PlanNode visitDistinctLimit(DistinctLimitNode node, List<PlanNode> newChildren) {
        return new DistinctLimitNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getLimit(), node.getHashSymbol());
    }

    @Override
    public PlanNode visitRemoteSource(RemoteSourceNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return node;
    }

    @Override
    public PlanNode visitExchange(ExchangeNode node, List<PlanNode> newChildren) {
        return new ExchangeNode(node.getId(), node.getType(), node.getPartitionFunction(), newChildren, node.getOutputSymbols(), node.getInputs());
    }

    @Override
    public PlanNode visitTopN(TopNNode node, List<PlanNode> newChildren) {
        return new TopNNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial());
    }

    @Override
    public PlanNode visitTableScan(TableScanNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return node;
    }

    @Override
    public PlanNode visitValues(ValuesNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return node;
    }

    @Override
    public PlanNode visitUnnest(UnnestNode node, List<PlanNode> newChildren) {
        return new UnnestNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getReplicateSymbols(), node.getUnnestSymbols(), node.getOrdinalitySymbol());
    }

    @Override
    public PlanNode visitProject(ProjectNode node, List<PlanNode> newChildren) {
        return new ProjectNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getAssignments());
    }

    @Override
    public PlanNode visitFilter(FilterNode node, List<PlanNode> newChildren) {
        return new FilterNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getPredicate());
    }

    @Override
    public PlanNode visitSample(SampleNode node, List<PlanNode> newChildren) {
        return new SampleNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getSampleRatio(), node.getSampleType(), node.isRescaled(), node.getSampleWeightSymbol());
    }

    @Override
    public PlanNode visitIndexSource(IndexSourceNode node, List<PlanNode> newChildren) {
        return node;
    }

    @Override
    public PlanNode visitJoin(JoinNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new JoinNode(node.getId(), node.getType(), newChildren.get(0), newChildren.get(1), node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
    }

    @Override
    public PlanNode visitSemiJoin(SemiJoinNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SemiJoinNode(node.getId(), newChildren.get(0), newChildren.get(1), node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol());
    }

    @Override
    public PlanNode visitIndexJoin(IndexJoinNode node, List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new IndexJoinNode(node.getId(), node.getType(), newChildren.get(0), newChildren.get(1), node.getCriteria(), node.getProbeHashSymbol(), node.getIndexHashSymbol());
    }

    @Override
    public PlanNode visitAggregation(AggregationNode node, List<PlanNode> newChildren) {
        return new AggregationNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
    }

    @Override
    public PlanNode visitMarkDistinct(MarkDistinctNode node, List<PlanNode> newChildren) {
        return new MarkDistinctNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getMarkerSymbol(), node.getDistinctSymbols(), node.getHashSymbol());
    }

    @Override
    public PlanNode visitWindow(WindowNode node, List<PlanNode> newChildren) {
        return new WindowNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getFrame(), node.getWindowFunctions(), node.getSignatures(), node.getHashSymbol(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
    }

    @Override
    public PlanNode visitTopNRowNumber(TopNRowNumberNode node, List<PlanNode> newChildren) {
        return new TopNRowNumberNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial(), node.getHashSymbol());
    }

    @Override
    public PlanNode visitRowNumber(RowNumberNode node, List<PlanNode> newChildren) {
        return new RowNumberNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.getHashSymbol());
    }

    @Override
    public PlanNode visitOutput(OutputNode node, List<PlanNode> newChildren) {
        return new OutputNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getColumnNames(), node.getOutputSymbols());
    }

    @Override
    public PlanNode visitSort(SortNode node, List<PlanNode> newChildren) {
        return new SortNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getOrderBy(), node.getOrderings());
    }

    @Override
    public PlanNode visitTableWriter(TableWriterNode node, List<PlanNode> newChildren) {
        return new TableWriterNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol());
    }

    @Override
    public PlanNode visitTableFinish(TableFinishNode node, List<PlanNode> newChildren) {
        return new TableFinishNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getTarget(), node.getOutputSymbols());
    }

    @Override
    public PlanNode visitUnion(UnionNode node, List<PlanNode> newChildren) {
        return new UnionNode(node.getId(), newChildren, node.getSymbolMapping());
    }

    @Override
    public PlanNode visitDelete(DeleteNode node, List<PlanNode> newChildren) {
        return new DeleteNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), node.getTarget(), node.getRowId(), node.getOutputSymbols());
    }

    @Override
    public PlanNode visitEnforceSingleRow(EnforceSingleRowNode node, List<PlanNode> newChildren) {
        return new EnforceSingleRowNode(node.getId(), (PlanNode)Iterables.getOnlyElement(newChildren));
    }
}

