/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PushTableWriteThroughUnion
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (!SystemSessionProperties.isPushTableWriteThroughUnion(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode sourceNode = context.rewrite(node.getSource());
            if (!(sourceNode instanceof UnionNode)) {
                return node;
            }
            UnionNode unionNode = (UnionNode)sourceNode;
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
            for (int i = 0; i < unionNode.getSources().size(); ++i) {
                PlanNode unionOriginalSource = unionNode.getSources().get(i);
                ImmutableList.Builder newSymbols = ImmutableList.builder();
                for (Symbol outputSymbol : node.getOutputSymbols()) {
                    Symbol newSymbol = this.symbolAllocator.newSymbol(outputSymbol.getName(), this.symbolAllocator.getTypes().get(outputSymbol));
                    newSymbols.add((Object)newSymbol);
                    mappings.put((Object)outputSymbol, (Object)newSymbol);
                }
                rewrittenSources.add((Object)new TableWriterNode(this.idAllocator.getNextId(), unionOriginalSource, node.getTarget(), unionNode.sourceOutputLayout(i), node.getColumnNames(), (List<Symbol>)newSymbols.build(), node.getSampleWeightSymbol()));
            }
            return new UnionNode(this.idAllocator.getNextId(), (List<PlanNode>)rewrittenSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build());
        }
    }
}

