/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PlanFragmenter {
    public SubPlan createSubPlans(Plan plan) {
        Fragmenter fragmenter = new Fragmenter(plan.getSymbolAllocator().getTypes());
        FragmentProperties properties = new FragmentProperties();
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan result = fragmenter.buildRootFragment(root, properties);
        result.sanityCheck();
        return result;
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private Optional<List<Symbol>> outputLayout = Optional.empty();
        private Optional<PartitionFunctionBinding> partitionFunction = Optional.empty();
        private Optional<PlanFragment.PlanDistribution> distribution = Optional.empty();
        private PlanNodeId distributeBy;

        private FragmentProperties() {
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.distribution.isPresent()) {
                PlanFragment.PlanDistribution value = this.distribution.get();
                Preconditions.checkState((value == PlanFragment.PlanDistribution.SINGLE || value == PlanFragment.PlanDistribution.COORDINATOR_ONLY ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.SINGLE, value});
            } else {
                this.distribution = Optional.of(PlanFragment.PlanDistribution.SINGLE);
            }
            return this;
        }

        public FragmentProperties setFixedDistribution() {
            this.distribution.ifPresent(current -> Preconditions.checkState((current == PlanFragment.PlanDistribution.FIXED ? 1 : 0) != 0, (String)"Cannot set distribution to %s. Already set to %s", (Object[])new Object[]{PlanFragment.PlanDistribution.FIXED, current}));
            this.distribution = Optional.of(PlanFragment.PlanDistribution.FIXED);
            return this;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            this.distribution.ifPresent(current -> Preconditions.checkState((this.distribution.get() == PlanFragment.PlanDistribution.SINGLE ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.COORDINATOR_ONLY, this.distribution.get()}));
            this.distribution = Optional.of(PlanFragment.PlanDistribution.COORDINATOR_ONLY);
            return this;
        }

        public FragmentProperties setSourceDistribution(PlanNodeId source) {
            if (this.distribution.isPresent()) {
                Preconditions.checkState((this.distribution.get() == PlanFragment.PlanDistribution.SINGLE || this.distribution.get() == PlanFragment.PlanDistribution.COORDINATOR_ONLY ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object[])new Object[]{PlanFragment.PlanDistribution.SOURCE, this.distribution.get()});
            } else {
                this.distribution = Optional.of(PlanFragment.PlanDistribution.SOURCE);
                this.distributeBy = source;
            }
            return this;
        }

        public FragmentProperties setUnpartitionedOutput() {
            this.partitionFunction.ifPresent(current -> {
                throw new IllegalStateException(String.format("Output overwrite partitioning with unpartitioned (currently set to %s)", current));
            });
            this.partitionFunction = Optional.empty();
            return this;
        }

        public FragmentProperties setOutputLayout(List<Symbol> layout) {
            this.outputLayout.ifPresent(current -> {
                throw new IllegalStateException(String.format("Cannot overwrite output layout with %s (currently set to %s)", layout, current));
            });
            this.outputLayout = Optional.of(layout);
            return this;
        }

        public FragmentProperties setPartitionedOutput(PartitionFunctionBinding partitionFunction) {
            if (this.partitionFunction.isPresent()) {
                throw new IllegalStateException(String.format("Cannot overwrite output partitioning with %s (currently set to %s)", partitionFunction, this.partitionFunction));
            }
            this.partitionFunction = Optional.of(partitionFunction);
            return this;
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public List<Symbol> getOutputLayout() {
            return this.outputLayout.get();
        }

        public Optional<PartitionFunctionBinding> getPartitionFunction() {
            return this.partitionFunction;
        }

        public PlanFragment.PlanDistribution getDistribution() {
            return this.distribution.get();
        }

        public PlanNodeId getDistributeBy() {
            return this.distributeBy;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Map<Symbol, Type> types;
        private int nextFragmentId = 1;

        public Fragmenter(Map<Symbol, Type> types) {
            this.types = types;
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            Set<Symbol> dependencies = SymbolExtractor.extract(root);
            PlanFragment fragment = new PlanFragment(fragmentId, root, Maps.filterKeys(this.types, (Predicate)Predicates.in(dependencies)), properties.getOutputLayout(), properties.getDistribution(), properties.getDistributeBy(), properties.getPartitionFunction());
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution().setOutputLayout(node.getOutputSymbols()).setUnpartitionedOutput();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSourceDistribution(node.getId());
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
                for (int i = 0; i < exchange.getSources().size(); ++i) {
                    FragmentProperties childProperties = new FragmentProperties();
                    childProperties.setUnpartitionedOutput();
                    childProperties.setOutputLayout(exchange.getInputs().get(i));
                    builder.add((Object)this.buildSubPlan(exchange.getSources().get(i), childProperties, context));
                }
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setFixedDistribution();
                FragmentProperties childProperties = new FragmentProperties().setPartitionedOutput(exchange.getPartitionFunction().get()).setOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs()));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            } else if (exchange.getType() == ExchangeNode.Type.REPLICATE) {
                FragmentProperties childProperties = new FragmentProperties();
                childProperties.setUnpartitionedOutput();
                childProperties.setOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs()));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableCollectors.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }
    }
}

