/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.client.ClientTypeSignature;
import com.facebook.presto.client.Column;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.client.StageStats;
import com.facebook.presto.client.StatementStats;
import com.facebook.presto.execution.BufferInfo;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.SharedBufferInfo;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.ResourceUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/statement")
public class StatementResource {
    private static final Logger log = Logger.get(StatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final long DESIRED_RESULT_BYTES = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();
    private final QueryManager queryManager;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final QueryIdGenerator queryIdGenerator;
    private final ConcurrentMap<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"query-purger"));

    @Inject
    public StatementResource(QueryManager queryManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager, ExchangeClientSupplier exchangeClientSupplier, QueryIdGenerator queryIdGenerator) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.exchangeClientSupplier = Objects.requireNonNull(exchangeClientSupplier, "exchangeClientSupplier is null");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.queryPurger.scheduleWithFixedDelay(new PurgeQueriesRunnable(this.queries, queryManager), 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Produces(value={"application/json"})
    public Response createQuery(String statement, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) throws InterruptedException {
        ResourceUtil.assertRequest(!Strings.isNullOrEmpty((String)statement), "SQL statement is empty", new Object[0]);
        Session session = ResourceUtil.createSessionForRequest(servletRequest, this.accessControl, this.sessionPropertyManager, this.queryIdGenerator.createNextQueryId());
        ExchangeClient exchangeClient = this.exchangeClientSupplier.get(deltaMemoryInBytes -> {});
        Query query = new Query(session, statement, this.queryManager, exchangeClient);
        this.queries.put(query.getQueryId(), query);
        return StatementResource.getQueryResults(query, Optional.empty(), uriInfo, new Duration(1.0, TimeUnit.MILLISECONDS));
    }

    @GET
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="maxWait") Duration maxWait, @Context UriInfo uriInfo) throws InterruptedException {
        Query query = (Query)this.queries.get(queryId);
        if (query == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        return StatementResource.getQueryResults(query, Optional.of(token), uriInfo, wait);
    }

    private static Response getQueryResults(Query query, Optional<Long> token, UriInfo uriInfo, Duration wait) throws InterruptedException {
        QueryResults queryResults = token.isPresent() ? query.getResults(token.get(), uriInfo, wait) : query.getNextResults(uriInfo, wait);
        Response.ResponseBuilder response = Response.ok((Object)queryResults);
        query.getSetSessionProperties().entrySet().stream().forEach(entry -> response.header("X-Presto-Set-Session", (Object)((String)entry.getKey() + '=' + (String)entry.getValue())));
        query.getResetSessionProperties().stream().forEach(name -> response.header("X-Presto-Clear-Session", name));
        query.getStartedTransactionId().ifPresent(transactionId -> response.header("X-Presto-Started-Transaction-Id", transactionId));
        if (query.isClearTransactionId()) {
            response.header("X-Presto-Clear-Transaction-Id", (Object)true);
        }
        return response.build();
    }

    @DELETE
    @Path(value="{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token) {
        Query query = (Query)this.queries.get(queryId);
        if (query == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        query.cancel();
        return Response.noContent().build();
    }

    private static class PurgeQueriesRunnable
    implements Runnable {
        private final ConcurrentMap<QueryId, Query> queries;
        private final QueryManager queryManager;

        public PurgeQueriesRunnable(ConcurrentMap<QueryId, Query> queries, QueryManager queryManager) {
            this.queries = queries;
            this.queryManager = queryManager;
        }

        @Override
        public void run() {
            try {
                for (QueryId queryId : ImmutableSet.copyOf(this.queries.keySet())) {
                    Query query = (Query)this.queries.get(queryId);
                    Optional<QueryState> state = this.queryManager.getQueryState(queryId);
                    if (!state.isPresent() || state.get() == QueryState.FAILED) {
                        query.dispose();
                    }
                    if (state.isPresent()) continue;
                    this.queries.remove(queryId);
                }
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old queries");
            }
        }
    }

    @ThreadSafe
    public static class Query {
        private final QueryManager queryManager;
        private final QueryId queryId;
        private final ExchangeClient exchangeClient;
        private final AtomicLong resultId = new AtomicLong();
        private final Session session;
        @GuardedBy(value="this")
        private QueryResults lastResult;
        @GuardedBy(value="this")
        private String lastResultPath;
        @GuardedBy(value="this")
        private List<Column> columns;
        @GuardedBy(value="this")
        private Map<String, String> setSessionProperties;
        @GuardedBy(value="this")
        private Set<String> resetSessionProperties;
        @GuardedBy(value="this")
        private Optional<TransactionId> startedTransactionId;
        @GuardedBy(value="this")
        private boolean clearTransactionId;
        @GuardedBy(value="this")
        private Long updateCount;

        public Query(Session session, String query, QueryManager queryManager, ExchangeClient exchangeClient) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(query, "query is null");
            Objects.requireNonNull(queryManager, "queryManager is null");
            Objects.requireNonNull(exchangeClient, "exchangeClient is null");
            this.session = session;
            this.queryManager = queryManager;
            QueryInfo queryInfo = queryManager.createQuery(session, query);
            this.queryId = queryInfo.getQueryId();
            this.exchangeClient = exchangeClient;
        }

        public void cancel() {
            this.queryManager.cancelQuery(this.queryId);
            this.dispose();
        }

        public void dispose() {
            this.exchangeClient.close();
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public synchronized Map<String, String> getSetSessionProperties() {
            return this.setSessionProperties;
        }

        public synchronized Set<String> getResetSessionProperties() {
            return this.resetSessionProperties;
        }

        public synchronized Optional<TransactionId> getStartedTransactionId() {
            return this.startedTransactionId;
        }

        public synchronized boolean isClearTransactionId() {
            return this.clearTransactionId;
        }

        public synchronized QueryResults getResults(long token, UriInfo uriInfo, Duration maxWaitTime) throws InterruptedException {
            String requestedPath = uriInfo.getAbsolutePath().getPath();
            if (this.lastResultPath != null && requestedPath.equals(this.lastResultPath)) {
                this.queryManager.getQueryInfo(this.queryId);
                this.queryManager.recordHeartbeat(this.queryId);
                return this.lastResult;
            }
            if (token < this.resultId.get()) {
                throw new WebApplicationException(Response.Status.GONE);
            }
            if (this.lastResult.getNextUri() == null || !requestedPath.equals(this.lastResult.getNextUri().getPath())) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return this.getNextResults(uriInfo, maxWaitTime);
        }

        public synchronized QueryResults getNextResults(UriInfo uriInfo, Duration maxWaitTime) throws InterruptedException {
            Number number;
            Iterator<List<Object>> iterator;
            ImmutableSet data = this.getData(maxWaitTime);
            QueryInfo queryInfo = this.queryManager.getQueryInfo(this.queryId);
            this.queryManager.recordHeartbeat(this.queryId);
            if (this.exchangeClient.isClosed() && !queryInfo.getState().isDone()) {
                this.queryManager.waitForStateChange(this.queryId, queryInfo.getState(), maxWaitTime);
                queryInfo = this.queryManager.getQueryInfo(this.queryId);
            }
            if (data != null && queryInfo.getUpdateType() != null && this.updateCount == null && this.columns.size() == 1 && this.columns.get(0).getType().equals("bigint") && (iterator = data.iterator()).hasNext() && (number = (Number)iterator.next().get(0)) != null) {
                this.updateCount = number.longValue();
            }
            if (queryInfo.getState().isDone()) {
                if (queryInfo.getState() != QueryState.FINISHED) {
                    this.exchangeClient.close();
                } else if (queryInfo.getOutputStage() == null) {
                    this.exchangeClient.close();
                    this.columns = ImmutableList.of((Object)new Column("result", "boolean", new ClientTypeSignature("boolean", (List)ImmutableList.of())));
                    data = ImmutableSet.of((Object)ImmutableList.of((Object)true));
                }
            }
            URI nextResultsUri = null;
            if (!queryInfo.getState().isDone() || !this.exchangeClient.isClosed()) {
                nextResultsUri = this.createNextResultsUri(uriInfo);
            }
            this.setSessionProperties = queryInfo.getSetSessionProperties();
            this.resetSessionProperties = queryInfo.getResetSessionProperties();
            this.startedTransactionId = queryInfo.getStartedTransactionId();
            this.clearTransactionId = queryInfo.isClearTransactionId();
            QueryResults queryResults = new QueryResults(this.queryId.toString(), uriInfo.getRequestUriBuilder().replaceQuery("").replacePath(queryInfo.getSelf().getPath()).build(new Object[0]), Query.findCancelableLeafStage(queryInfo), nextResultsUri, this.columns, (Iterable)data, Query.toStatementStats(queryInfo), Query.toQueryError(queryInfo), queryInfo.getUpdateType(), this.updateCount);
            this.lastResultPath = this.lastResult != null && this.lastResult.getNextUri() != null ? this.lastResult.getNextUri().getPath() : null;
            this.lastResult = queryResults;
            return queryResults;
        }

        private synchronized Iterable<List<Object>> getData(Duration maxWait) throws InterruptedException {
            long bytes;
            Page page;
            QueryInfo queryInfo = this.queryManager.getQueryInfo(this.queryId);
            while (maxWait.toMillis() > 1L && !Query.isQueryStarted(queryInfo)) {
                this.queryManager.recordHeartbeat(this.queryId);
                maxWait = this.queryManager.waitForStateChange(this.queryId, queryInfo.getState(), maxWait);
                queryInfo = this.queryManager.getQueryInfo(this.queryId);
            }
            if (!Query.isQueryStarted(queryInfo) || queryInfo.getOutputStage() == null) {
                return null;
            }
            if (this.columns == null) {
                this.columns = Query.createColumnsList(queryInfo);
            }
            List<Type> types = queryInfo.getOutputStage().getTypes();
            this.updateExchangeClient(queryInfo.getOutputStage());
            ImmutableList.Builder pages = ImmutableList.builder();
            for (bytes = 0L; bytes < DESIRED_RESULT_BYTES && (page = this.exchangeClient.getNextPage(maxWait)) != null; bytes += page.getSizeInBytes()) {
                pages.add((Object)new RowIterable(this.session.toConnectorSession(), types, page));
                maxWait = new Duration(0.0, TimeUnit.MILLISECONDS);
            }
            if (bytes == 0L) {
                return null;
            }
            return Iterables.concat((Iterable)pages.build());
        }

        private static boolean isQueryStarted(QueryInfo queryInfo) {
            QueryState state = queryInfo.getState();
            return state != QueryState.QUEUED && queryInfo.getState() != QueryState.PLANNING && queryInfo.getState() != QueryState.STARTING;
        }

        private synchronized void updateExchangeClient(StageInfo outputStage) {
            if (!outputStage.getState().isDone()) {
                for (TaskInfo taskInfo : outputStage.getTasks()) {
                    SharedBufferInfo outputBuffers = taskInfo.getOutputBuffers();
                    List<BufferInfo> buffers = outputBuffers.getBuffers();
                    if (buffers.isEmpty() || outputBuffers.getState().canAddBuffers()) continue;
                    Preconditions.checkState((buffers.size() == 1 ? 1 : 0) != 0, (String)"Expected a single output buffer for task %s, but found %s", (Object[])new Object[]{taskInfo.getTaskId(), buffers});
                    TaskId bufferId = ((BufferInfo)Iterables.getOnlyElement(buffers)).getBufferId();
                    URI uri = HttpUriBuilder.uriBuilderFrom((URI)taskInfo.getSelf()).appendPath("results").appendPath(bufferId.toString()).build();
                    this.exchangeClient.addLocation(uri);
                }
            }
            if (Query.allOutputBuffersCreated(outputStage)) {
                this.exchangeClient.noMoreLocations();
            }
        }

        private static boolean allOutputBuffersCreated(StageInfo outputStage) {
            StageState stageState = outputStage.getState();
            if (stageState.isDone()) {
                return true;
            }
            if (stageState == StageState.PLANNED || stageState == StageState.SCHEDULING) {
                return false;
            }
            return outputStage.getTasks().stream().allMatch(taskInfo -> !taskInfo.getOutputBuffers().getState().canAddBuffers());
        }

        private synchronized URI createNextResultsUri(UriInfo uriInfo) {
            return uriInfo.getBaseUriBuilder().replacePath("/v1/statement").path(this.queryId.toString()).path(String.valueOf(this.resultId.incrementAndGet())).replaceQuery("").build(new Object[0]);
        }

        private static List<Column> createColumnsList(QueryInfo queryInfo) {
            Objects.requireNonNull(queryInfo, "queryInfo is null");
            StageInfo outputStage = queryInfo.getOutputStage();
            Objects.requireNonNull(outputStage, "outputStage is null");
            List<String> names = queryInfo.getFieldNames();
            List<Type> types = outputStage.getTypes();
            Preconditions.checkArgument((names.size() == types.size() ? 1 : 0) != 0, (Object)"names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < names.size(); ++i) {
                String name = names.get(i);
                TypeSignature typeSignature = types.get(i).getTypeSignature();
                String type = typeSignature.toString();
                list.add((Object)new Column(name, type, new ClientTypeSignature(typeSignature)));
            }
            return list.build();
        }

        private static StatementStats toStatementStats(QueryInfo queryInfo) {
            QueryStats queryStats = queryInfo.getQueryStats();
            return StatementStats.builder().setState(queryInfo.getState().toString()).setScheduled(queryInfo.isScheduled()).setNodes(Query.globalUniqueNodes(queryInfo.getOutputStage()).size()).setTotalSplits(queryStats.getTotalDrivers()).setQueuedSplits(queryStats.getQueuedDrivers()).setRunningSplits(queryStats.getRunningDrivers()).setCompletedSplits(queryStats.getCompletedDrivers()).setUserTimeMillis(queryStats.getTotalUserTime().toMillis()).setCpuTimeMillis(queryStats.getTotalCpuTime().toMillis()).setWallTimeMillis(queryStats.getTotalScheduledTime().toMillis()).setProcessedRows(queryStats.getRawInputPositions()).setProcessedBytes(queryStats.getRawInputDataSize().toBytes()).setRootStage(Query.toStageStats(queryInfo.getOutputStage())).build();
        }

        private static StageStats toStageStats(StageInfo stageInfo) {
            if (stageInfo == null) {
                return null;
            }
            com.facebook.presto.execution.StageStats stageStats = stageInfo.getStageStats();
            ImmutableList.Builder subStages = ImmutableList.builder();
            for (StageInfo subStage : stageInfo.getSubStages()) {
                subStages.add((Object)Query.toStageStats(subStage));
            }
            HashSet<String> uniqueNodes = new HashSet<String>();
            for (TaskInfo task : stageInfo.getTasks()) {
                URI uri = task.getSelf();
                uniqueNodes.add(uri.getHost() + ":" + uri.getPort());
            }
            return StageStats.builder().setStageId(String.valueOf(stageInfo.getStageId().getId())).setState(stageInfo.getState().toString()).setDone(stageInfo.getState().isDone()).setNodes(uniqueNodes.size()).setTotalSplits(stageStats.getTotalDrivers()).setQueuedSplits(stageStats.getQueuedDrivers()).setRunningSplits(stageStats.getRunningDrivers()).setCompletedSplits(stageStats.getCompletedDrivers()).setUserTimeMillis(stageStats.getTotalUserTime().toMillis()).setCpuTimeMillis(stageStats.getTotalCpuTime().toMillis()).setWallTimeMillis(stageStats.getTotalScheduledTime().toMillis()).setProcessedRows(stageStats.getRawInputPositions()).setProcessedBytes(stageStats.getRawInputDataSize().toBytes()).setSubStages((List)subStages.build()).build();
        }

        private static Set<String> globalUniqueNodes(StageInfo stageInfo) {
            if (stageInfo == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder nodes = ImmutableSet.builder();
            for (TaskInfo task : stageInfo.getTasks()) {
                URI uri = task.getSelf();
                nodes.add((Object)(uri.getHost() + ":" + uri.getPort()));
            }
            for (StageInfo subStage : stageInfo.getSubStages()) {
                nodes.addAll(Query.globalUniqueNodes(subStage));
            }
            return nodes.build();
        }

        private static URI findCancelableLeafStage(QueryInfo queryInfo) {
            if (queryInfo.getOutputStage() == null) {
                return null;
            }
            return Query.findCancelableLeafStage(queryInfo.getOutputStage());
        }

        private static URI findCancelableLeafStage(StageInfo stage) {
            if (stage.getState().isDone()) {
                return null;
            }
            for (StageInfo subStage : Lists.reverse(stage.getSubStages())) {
                URI leafStage = Query.findCancelableLeafStage(subStage);
                if (leafStage == null) continue;
                return leafStage;
            }
            return stage.getSelf();
        }

        private static QueryError toQueryError(QueryInfo queryInfo) {
            ErrorCode errorCode;
            FailureInfo failure = queryInfo.getFailureInfo();
            if (failure == null) {
                QueryState state = queryInfo.getState();
                if (!state.isDone() || state == QueryState.FINISHED) {
                    return null;
                }
                log.warn("Query %s in state %s has no failure info", new Object[]{queryInfo.getQueryId(), state});
                failure = Failures.toFailure(new RuntimeException(String.format("Query is %s (reason unknown)", new Object[]{state}))).toFailureInfo();
            }
            if (queryInfo.getErrorCode() != null) {
                errorCode = queryInfo.getErrorCode();
            } else {
                errorCode = StandardErrorCode.INTERNAL_ERROR.toErrorCode();
                log.warn("Failed query %s has no error code", new Object[]{queryInfo.getQueryId()});
            }
            return new QueryError(failure.getMessage(), null, errorCode.getCode(), errorCode.getName(), StandardErrorCode.toErrorType((int)errorCode.getCode()).toString(), failure.getErrorLocation(), failure);
        }

        private static class RowIterator
        extends AbstractIterator<List<Object>> {
            private final ConnectorSession session;
            private final List<Type> types;
            private final Page page;
            private int position = -1;

            private RowIterator(ConnectorSession session, List<Type> types, Page page) {
                this.session = session;
                this.types = types;
                this.page = page;
            }

            protected List<Object> computeNext() {
                ++this.position;
                if (this.position >= this.page.getPositionCount()) {
                    return (List)this.endOfData();
                }
                ArrayList<Object> values = new ArrayList<Object>(this.page.getChannelCount());
                for (int channel = 0; channel < this.page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = this.page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, this.position));
                }
                return Collections.unmodifiableList(values);
            }
        }

        private static class RowIterable
        implements Iterable<List<Object>> {
            private final ConnectorSession session;
            private final List<Type> types;
            private final Page page;

            private RowIterable(ConnectorSession session, List<Type> types, Page page) {
                this.session = session;
                this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
                this.page = Objects.requireNonNull(page, "page is null");
            }

            @Override
            public Iterator<List<Object>> iterator() {
                return new RowIterator(this.session, this.types, this.page);
            }
        }
    }
}

