/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.AddColumnTask;
import com.facebook.presto.execution.CallTask;
import com.facebook.presto.execution.CommitTask;
import com.facebook.presto.execution.CreateTableTask;
import com.facebook.presto.execution.CreateViewTask;
import com.facebook.presto.execution.DataDefinitionExecution;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.DropTableTask;
import com.facebook.presto.execution.DropViewTask;
import com.facebook.presto.execution.ForQueryExecution;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryExecutionMBean;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.RenameColumnTask;
import com.facebook.presto.execution.RenameTableTask;
import com.facebook.presto.execution.ResetSessionTask;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.execution.SqlQueryQueueManager;
import com.facebook.presto.execution.StartTransactionTask;
import com.facebook.presto.execution.scheduler.AllAtOnceExecutionPolicy;
import com.facebook.presto.execution.scheduler.ExecutionPolicy;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerExporter;
import com.facebook.presto.execution.scheduler.PhasedExecutionPolicy;
import com.facebook.presto.metadata.DiscoveryNodeManager;
import com.facebook.presto.metadata.ForGracefulShutdown;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.server.QueryResource;
import com.facebook.presto.server.StageResource;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Use;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
implements Module {
    public void configure(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/", "webapp").withWelcomeFile("index.html");
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StageResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(QueryQueueManager.class).to(SqlQueryQueueManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryManager.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
        binder.bind(QueryExplainer.class).in(Scopes.SINGLETON);
        binder.bind(SplitManager.class).in(Scopes.SINGLETON);
        binder.bind(SessionPropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(SystemSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(TablePropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(InternalNodeManager.class).to(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        binder.bind(NodeManager.class).to(Key.get(InternalNodeManager.class)).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSchedulerConfig.class);
        binder.bind(NodeScheduler.class).in(Scopes.SINGLETON);
        binder.bind(NodeSchedulerExporter.class).in(Scopes.SINGLETON);
        binder.bind(NodeTaskMap.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NodeScheduler.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("node-manager", ForGracefulShutdown.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(2.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s")));
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(ObjectNames.generatedNameOf(QueryExecution.class));
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Query.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Explain.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowColumns.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowPartitions.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowFunctions.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowTables.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowSchemas.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowCatalogs.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Use.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowSession.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(CreateTableAsSelect.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Insert.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Delete.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        binder.bind(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, AddColumn.class, AddColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateTable.class, CreateTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameTable.class, RenameTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, RenameColumn.class, RenameColumnTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropTable.class, DropTableTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, CreateView.class, CreateViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, DropView.class, DropViewTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, SetSession.class, SetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, ResetSession.class, ResetSessionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, StartTransaction.class, StartTransactionTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Commit.class, CommitTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Rollback.class, RollbackTask.class);
        CoordinatorModule.bindDataDefinitionTask(binder, executionBinder, Call.class, CallTask.class);
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ViewDefinition.class);
    }

    private static <T extends Statement> void bindDataDefinitionTask(Binder binder, MapBinder<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionBinder, Class<T> statement, Class<? extends DataDefinitionTask<T>> task) {
        MapBinder taskBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<DataDefinitionTask<?>>(){});
        taskBinder.addBinding(statement).to(task).in(Scopes.SINGLETON);
        executionBinder.addBinding(statement).to(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
    }
}

