/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class RowEqualOperator
extends SqlOperator {
    public static final RowEqualOperator ROW_EQUAL = new RowEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowEqualOperator.class, "equals", Type.class, Block.class, Block.class);

    private RowEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), "boolean", (List<String>)ImmutableList.of((Object)"T", (Object)"T"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(type), this.isDeterministic());
    }

    public static boolean equals(Type rowType, Block leftRow, Block rightRow) {
        BlockBuilder leftBlockBuilder = rowType.createBlockBuilder(new BlockBuilderStatus(), 1);
        BlockBuilder rightBlockBuilder = rowType.createBlockBuilder(new BlockBuilderStatus(), 1);
        rowType.writeObject(leftBlockBuilder, (Object)leftRow);
        rowType.writeObject(rightBlockBuilder, (Object)rightRow);
        return rowType.equalTo(leftBlockBuilder.build(), 0, rightBlockBuilder.build(), 0);
    }
}

