/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.MapEqualOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class MapNotEqualOperator
extends SqlOperator {
    public static final MapNotEqualOperator MAP_NOT_EQUAL = new MapNotEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapNotEqualOperator.class, "notEqual", MethodHandle.class, MethodHandle.class, MethodHandle.class, Type.class, Type.class, Block.class, Block.class);

    private MapNotEqualOperator() {
        super(OperatorType.NOT_EQUAL, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.comparableTypeParameter("V")), "boolean", (List<String>)ImmutableList.of((Object)"map<K,V>", (Object)"map<K,V>"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        MethodHandle keyEqualsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        MethodHandle keyHashcodeFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)keyType))).getMethodHandle();
        MethodHandle valueEqualsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)valueType, (Object)valueType))).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(keyEqualsFunction).bindTo(keyHashcodeFunction).bindTo(valueEqualsFunction).bindTo(keyType).bindTo(valueType);
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), method, this.isDeterministic());
    }

    public static Boolean notEqual(MethodHandle keyEqualsFunction, MethodHandle keyHashcodeFunction, MethodHandle valueEqualsFunction, Type keyType, Type valueType, Block left, Block right) {
        Boolean equals = MapEqualOperator.equals(keyEqualsFunction, keyHashcodeFunction, valueEqualsFunction, keyType, valueType, left, right);
        if (equals == null) {
            return null;
        }
        return equals == false;
    }
}

