/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class MapCardinalityFunction
extends SqlScalarFunction {
    public static final MapCardinalityFunction MAP_CARDINALITY = new MapCardinalityFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapCardinalityFunction.class, "mapCardinality", Block.class);

    public MapCardinalityFunction() {
        super("cardinality", (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("K"), (Object)Signature.typeParameter("V")), "bigint", (List<String>)ImmutableList.of((Object)"map<K,V>"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Cardinality expects only one argument");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), METHOD_HANDLE, this.isDeterministic());
    }

    public static long mapCardinality(Block block) {
        return block.getPositionCount() / 2;
    }
}

