/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class JsonToMapCast
extends SqlOperator {
    public static final JsonToMapCast JSON_TO_MAP = new JsonToMapCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToMapCast.class, "toMap", Type.class, ConnectorSession.class, Slice.class);

    private JsonToMapCast() {
        super(OperatorType.CAST, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeParameter("V")), "map<K,V>", (List<String>)ImmutableList.of((Object)"json"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type keyType = types.get("K");
        Type valueType = types.get("V");
        Type mapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)keyType.getTypeSignature(), (Object)valueType.getTypeSignature()), (List)ImmutableList.of());
        Failures.checkCondition(TypeJsonUtils.canCastFromJson(mapType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", mapType);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(mapType);
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, this.isDeterministic());
    }

    public static Block toMap(Type mapType, ConnectorSession connectorSession, Slice json) {
        try {
            Map map = (Map)TypeJsonUtils.stackRepresentationToObject(connectorSession, json, mapType);
            if (map == null) {
                return null;
            }
            Type keyType = ((MapType)mapType).getKeyType();
            Type valueType = ((MapType)mapType).getValueType();
            InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), map.size() * 2);
            for (Map.Entry entry : map.entrySet()) {
                TypeJsonUtils.appendToBlockBuilder(keyType, entry.getKey(), (BlockBuilder)blockBuilder);
                TypeJsonUtils.appendToBlockBuilder(valueType, entry.getValue(), (BlockBuilder)blockBuilder);
            }
            return blockBuilder.build();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to " + mapType, (Throwable)e);
        }
    }
}

