/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.operator.scalar.JsonPath;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.primitives.Doubles;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.annotation.Nullable;

public final class JsonFunctions {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final JsonFactory MAPPING_JSON_FACTORY = new MappingJsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    private JsonFunctions() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castJsonToVarchar(@SqlType(value="json") Slice slice) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "`CAST (jsonValue as VARCHAR)` is removed. Use `JSON_FORMAT(jsonValue)`.");
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castVarcharToJson(@SqlType(value="varchar") Slice slice) throws IOException {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "`CAST (varcharValue as JSON)` is removed. Use `JSON_PARSE(varcharValue)`.");
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="JsonPath")
    public static JsonPath castToJsonPath(@SqlType(value="varchar") Slice pattern) {
        return new JsonPath(pattern.toStringUtf8());
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice jsonFormat(@SqlType(value="json") Slice slice) {
        return slice;
    }

    @ScalarFunction
    @SqlType(value="json")
    public static Slice jsonParse(@SqlType(value="varchar") Slice slice) {
        try {
            byte[] in = slice.getBytes();
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(in.length);
            SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(in, Object.class));
            return dynamicSliceOutput.slice();
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert '%s' to JSON", slice.toStringUtf8()));
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_length")
    @SqlType(value="bigint")
    public static Long varcharJsonArrayLength(@SqlType(value="varchar") Slice json) {
        return JsonFunctions.jsonArrayLength(json);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="bigint")
    public static Long jsonArrayLength(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Long l = null;
                return l;
            }
            long length = 0L;
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Long l = null;
                    return l;
                }
                if (token == JsonToken.END_ARRAY) {
                    Long l = length;
                    return l;
                }
                parser.skipChildren();
                ++length;
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_contains")
    @SqlType(value="boolean")
    public static Boolean varcharJsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="boolean") boolean value) {
        return JsonFunctions.jsonArrayContains(json, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="json") Slice json, @SqlType(value="boolean") boolean value) {
        try (JsonParser parser = JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_TRUE && value || token == JsonToken.VALUE_FALSE && !value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_contains")
    @SqlType(value="boolean")
    public static Boolean varcharJsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="bigint") long value) {
        return JsonFunctions.jsonArrayContains(json, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="json") Slice json, @SqlType(value="bigint") long value) {
        try (JsonParser parser = JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_INT && (parser.getNumberType() == JsonParser.NumberType.INT || parser.getNumberType() == JsonParser.NumberType.LONG) && parser.getLongValue() == value) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_contains")
    @SqlType(value="boolean")
    public static Boolean varcharJsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="double") double value) {
        return JsonFunctions.jsonArrayContains(json, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="json") Slice json, @SqlType(value="double") double value) {
        if (!Doubles.isFinite((double)value)) {
            return false;
        }
        try (JsonParser parser = JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_NUMBER_FLOAT && parser.getDoubleValue() == value && Doubles.isFinite((double)parser.getDoubleValue())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_contains")
    @SqlType(value="boolean")
    public static Boolean varcharJsonArrayContains(@SqlType(value="varchar") Slice json, @SqlType(value="varchar") Slice value) {
        return JsonFunctions.jsonArrayContains(json, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="boolean")
    public static Boolean jsonArrayContains(@SqlType(value="json") Slice json, @SqlType(value="varchar") Slice value) {
        String valueString = value.toStringUtf8();
        try (JsonParser parser = JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Boolean bl = null;
                return bl;
            }
            while (true) {
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    Boolean bl = null;
                    return bl;
                }
                if (token == JsonToken.END_ARRAY) {
                    Boolean bl = false;
                    return bl;
                }
                parser.skipChildren();
                if (token == JsonToken.VALUE_STRING && valueString.equals(parser.getValueAsString())) {
                    Boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    @ScalarFunction(value="json_array_get")
    @SqlType(value="json")
    public static Slice varcharJsonArrayGet(@SqlType(value="varchar") Slice json, @SqlType(value="bigint") long index) {
        return JsonFunctions.jsonArrayGet(json, index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ScalarFunction
    @SqlType(value="json")
    public static Slice jsonArrayGet(@SqlType(value="json") Slice json, @SqlType(value="bigint") long index) {
        try (JsonParser parser = MAPPING_JSON_FACTORY.createParser((InputStream)json.getInput());){
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                Slice slice = null;
                return slice;
            }
            LinkedList<String> tokens = null;
            if (index < 0L) {
                tokens = new LinkedList<String>();
            }
            long count = 0L;
            while (true) {
                Slice slice;
                JsonToken token;
                if ((token = parser.nextToken()) == null) {
                    slice = null;
                    return slice;
                }
                if (token == JsonToken.END_ARRAY) {
                    if (tokens != null && count >= index * -1L) {
                        slice = Slices.utf8Slice((String)((String)tokens.get(0)));
                        return slice;
                    }
                    slice = null;
                    return slice;
                }
                String arrayElement = token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY ? parser.readValueAsTree().toString() : parser.getValueAsString();
                if (count == index) {
                    Slice slice2 = arrayElement == null ? null : Slices.utf8Slice((String)arrayElement);
                    return slice2;
                }
                if (tokens != null) {
                    tokens.add(arrayElement);
                    if (count >= index * -1L) {
                        tokens.remove(0);
                    }
                }
                ++count;
                continue;
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @ScalarFunction(value="json_extract_scalar")
    @Nullable
    @SqlType(value="varchar")
    public static Slice varcharJsonExtractScalar(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getScalarExtractor());
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="varchar")
    public static Slice jsonExtractScalar(@SqlType(value="json") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getScalarExtractor());
    }

    @ScalarFunction(value="json_extract")
    @Nullable
    @SqlType(value="json")
    public static Slice varcharJsonExtract(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getObjectExtractor());
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="json")
    public static Slice jsonExtract(@SqlType(value="json") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getObjectExtractor());
    }

    @ScalarFunction(value="json_size")
    @Nullable
    @SqlType(value="bigint")
    public static Long varcharJsonSize(@SqlType(value="varchar") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getSizeExtractor());
    }

    @ScalarFunction
    @Nullable
    @SqlType(value="bigint")
    public static Long jsonSize(@SqlType(value="json") Slice json, @SqlType(value="JsonPath") JsonPath jsonPath) {
        return JsonExtract.extract(json, jsonPath.getSizeExtractor());
    }
}

