/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArraySliceFunction
extends SqlScalarFunction {
    public static final ArraySliceFunction ARRAY_SLICE_FUNCTION = new ArraySliceFunction();
    private static final String FUNCTION_NAME = "slice";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArraySliceFunction.class, "slice", Type.class, Block.class, Long.TYPE, Long.TYPE);

    public ArraySliceFunction() {
        super(FUNCTION_NAME, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"bigint", (Object)"bigint"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Subsets an array given an offset (1-indexed) and length";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(type);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false, (Object)false), methodHandle, this.isDeterministic());
    }

    public static Block slice(Type type, Block array, long fromIndex, long length) {
        long toIndex;
        Failures.checkCondition(length >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid array length", new Object[0]);
        Failures.checkCondition(fromIndex != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid start index", new Object[0]);
        int size = array.getPositionCount();
        if (size == 0) {
            return array;
        }
        if (fromIndex < 0L) {
            fromIndex = (long)size + fromIndex + 1L;
        }
        if (fromIndex >= (toIndex = Math.min(fromIndex + length, (long)(size + 1))) || fromIndex < 0L || toIndex < 0L) {
            return type.createBlockBuilder(new BlockBuilderStatus(), 0).build();
        }
        return array.getRegion((int)(fromIndex - 1L), (int)(toIndex - fromIndex));
    }
}

