/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public final class ArrayPositionFunction
extends SqlScalarFunction {
    public static final ArrayPositionFunction ARRAY_POSITION = new ArrayPositionFunction();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArrayPositionFunction.class, "arrayPosition", Type.class, MethodHandle.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArrayPositionFunction.class, "arrayPosition", Type.class, MethodHandle.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArrayPositionFunction.class, "arrayPosition", Type.class, MethodHandle.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArrayPositionFunction.class, "arrayPosition", Type.class, MethodHandle.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArrayPositionFunction.class, "arrayPosition", Type.class, MethodHandle.class, Block.class, Object.class);

    public ArrayPositionFunction() {
        super("array_position", (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.comparableTypeParameter("E")), "bigint", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"E"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Returns the position of the first occurrence of the given value in array (or 0 if not found)";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("E");
        MethodHandle equalMethodHandle = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))).getMethodHandle();
        MethodHandle arrayPositionMethodHandle = type.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (type.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (type.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (type.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), arrayPositionMethodHandle.bindTo(type).bindTo(equalMethodHandle), this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static long arrayPosition(Type type, MethodHandle equalMethodHandle, Block array, boolean element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            boolean arrayValue = type.getBoolean(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @UsedByGeneratedCode
    public static long arrayPosition(Type type, MethodHandle equalMethodHandle, Block array, long element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            long arrayValue = type.getLong(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @UsedByGeneratedCode
    public static long arrayPosition(Type type, MethodHandle equalMethodHandle, Block array, double element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            double arrayValue = type.getDouble(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @UsedByGeneratedCode
    public static long arrayPosition(Type type, MethodHandle equalMethodHandle, Block array, Slice element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Slice arrayValue = type.getSlice(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @UsedByGeneratedCode
    public static long arrayPosition(Type type, MethodHandle equalMethodHandle, Block array, Object element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Object arrayValue = type.getObject(array, i);
            try {
                if (!equalMethodHandle.invoke(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }
}

