/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ArrayConstructor
extends SqlScalarFunction {
    public static final ArrayConstructor ARRAY_CONSTRUCTOR = new ArrayConstructor();

    public ArrayConstructor() {
        super("array_constructor", (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"E", (Object)"E"), true);
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle methodHandle;
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Can only construct arrays from exactly matching types");
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = types.get("E");
        for (int i = 0; i < arity; ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        try {
            Method method = clazz.getMethod("arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(stackTypes.size(), true));
        return new ScalarFunctionImplementation(false, (List<Boolean>)nullableParameters, methodHandle, this.isDeterministic());
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        List stackTypeNames = (List)stackTypes.stream().map(Class::getSimpleName).collect(ImmutableCollectors.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor")), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)Parameter.arg((String)("arg" + i), stackType));
        }
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "arrayConstructor", ParameterizedType.type(Block.class), (Iterable)parameters.build());
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable blockBuilderVariable = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        CallSiteBinder binder = new CallSiteBinder();
        BytecodeExpression createBlockBuilder = blockBuilderVariable.set(SqlTypeBytecodeExpression.constantType(binder, elementType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0]), BytecodeExpressions.constantInt((int)stackTypes.size())}));
        body.append((BytecodeNode)createBlockBuilder);
        for (int i = 0; i < stackTypes.size(); ++i) {
            if (elementType.getJavaType() == Void.TYPE) {
                body.append((BytecodeNode)blockBuilderVariable.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]));
                continue;
            }
            Variable argument = scope.getVariable("arg" + i);
            IfStatement ifStatement = new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)argument, (BytecodeExpression)BytecodeExpressions.constantNull(stackTypes.get(i)))).ifTrue((BytecodeNode)blockBuilderVariable.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, elementType).writeValue((BytecodeExpression)blockBuilderVariable, argument.cast(elementType.getJavaType())));
            body.append((BytecodeNode)ifStatement);
        }
        body.append((BytecodeNode)blockBuilderVariable.invoke("build", Block.class, new BytecodeExpression[0]).ret());
        return CompilerUtils.defineClass((ClassDefinition)definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(ArrayConstructor.class.getClassLoader()));
    }
}

