/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ArrayConcatUtils;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ArrayConcatFunction
extends SqlScalarFunction {
    public static final ArrayConcatFunction ARRAY_CONCAT_FUNCTION = new ArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final MethodHandle CONSTRUCTOR = Reflection.constructorMethodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, ArrayConcatUtils.class, Type.class);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayConcatUtils.class, "concat", Type.class, Block.class, Block.class);

    public ArrayConcatFunction() {
        super(FUNCTION_NAME, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"array<E>", (Object)"array<E>"));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Concatenates given arrays";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type elementType = types.get("E");
        MethodType newType = METHOD_HANDLE.type().changeParameterType(0, Type.class).changeParameterType(1, ArrayConcatUtils.class);
        int[] permutedIndices = new int[newType.parameterCount()];
        permutedIndices[0] = 1;
        permutedIndices[1] = 0;
        for (int i = 2; i < permutedIndices.length; ++i) {
            permutedIndices[i] = i;
        }
        MethodHandle methodHandle = MethodHandles.permuteArguments(METHOD_HANDLE, newType, permutedIndices);
        methodHandle = methodHandle.bindTo(elementType);
        MethodHandle instanceFactory = CONSTRUCTOR.bindTo(elementType);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), methodHandle, Optional.of(instanceFactory), this.isDeterministic());
    }
}

