/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.stats.QuantileDigest;
import java.io.DataInput;
import java.io.DataOutput;

public class DigestAndPercentileStateSerializer
implements AccumulatorStateSerializer<DigestAndPercentileState> {
    @Override
    public Type getSerializedType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public void serialize(DigestAndPercentileState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(state.getDigest().estimatedSerializedSizeInBytes() + 8);
            state.getDigest().serialize((DataOutput)sliceOutput);
            sliceOutput.appendDouble(state.getPercentile());
            Slice slice = sliceOutput.slice();
            VarcharType.VARCHAR.writeSlice(out, slice);
        }
    }

    @Override
    public void deserialize(Block block, int index, DigestAndPercentileState state) {
        if (!block.isNull(index)) {
            BasicSliceInput input = VarcharType.VARCHAR.getSlice(block, index).getInput();
            state.setDigest(QuantileDigest.deserialize((DataInput)input));
            state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
            state.setPercentile(input.readDouble());
        }
    }
}

