/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import java.util.List;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileArrayAggregations {
    public static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_ARRAY_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateLongPercentileArrayAggregations.class, (Type)new ArrayType((Type)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)((Object)new ArrayType((Type)DoubleType.DOUBLE))));
    public static final InternalAggregationFunction LONG_APPROXIMATE_PERCENTILE_ARRAY_WEIGHTED_AGGREGATION = new AggregationCompiler().generateAggregationFunction(ApproximateLongPercentileArrayAggregations.class, (Type)new ArrayType((Type)BigintType.BIGINT), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)((Object)new ArrayType((Type)DoubleType.DOUBLE))));

    private ApproximateLongPercentileArrayAggregations() {
    }

    @InputFunction
    public static void input(DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="array<double>") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateLongPercentileArrayAggregations.initializeDigest(state);
        QuantileDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @InputFunction
    public static void weightedInput(DigestAndPercentileArrayState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="array<double>") Block percentilesArrayBlock) {
        ApproximateLongPercentileArrayAggregations.initializePercentilesArray(state, percentilesArrayBlock);
        ApproximateLongPercentileArrayAggregations.initializeDigest(state);
        QuantileDigest digest = state.getDigest();
        state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(DigestAndPercentileArrayState state, DigestAndPercentileArrayState otherState) {
        QuantileDigest otherDigest = otherState.getDigest();
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            state.setDigest(otherDigest);
            state.addMemoryUsage(otherDigest.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
            digest.merge(otherDigest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
        state.setPercentiles(otherState.getPercentiles());
    }

    @OutputFunction(value="array<bigint>")
    public static void output(DigestAndPercentileArrayState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        List<Double> percentiles = state.getPercentiles();
        if (percentiles == null || digest == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        for (int i = 0; i < percentiles.size(); ++i) {
            Double percentile = percentiles.get(i);
            BigintType.BIGINT.writeLong(blockBuilder, digest.getQuantile(percentile.doubleValue()));
        }
        out.closeEntry();
    }

    private static void initializePercentilesArray(DigestAndPercentileArrayState state, Block percentilesArrayBlock) {
        if (state.getPercentiles() == null) {
            ImmutableList.Builder percentilesListBuilder = ImmutableList.builder();
            for (int i = 0; i < percentilesArrayBlock.getPositionCount(); ++i) {
                Failures.checkCondition(!percentilesArrayBlock.isNull(i), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile cannot be null", new Object[0]);
                double percentile = DoubleType.DOUBLE.getDouble(percentilesArrayBlock, i);
                Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
                percentilesListBuilder.add((Object)percentile);
            }
            state.setPercentiles((List<Double>)percentilesListBuilder.build());
        }
    }

    private static void initializeDigest(DigestAndPercentileArrayState state) {
        QuantileDigest digest = state.getDigest();
        if (digest == null) {
            digest = new QuantileDigest(0.01);
            state.setDigest(digest);
            state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
        }
    }
}

