/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WindowFunctionDefinition {
    private final WindowFunctionSupplier functionSupplier;
    private final Type type;
    private final List<Integer> argumentChannels;

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, List<Integer> inputs) {
        Objects.requireNonNull(functionSupplier, "functionSupplier is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(inputs, "inputs is null");
        return new WindowFunctionDefinition(functionSupplier, type, inputs);
    }

    public static WindowFunctionDefinition window(WindowFunctionSupplier functionSupplier, Type type, Integer ... inputs) {
        Objects.requireNonNull(functionSupplier, "functionSupplier is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(inputs, "inputs is null");
        return WindowFunctionDefinition.window(functionSupplier, type, Arrays.asList(inputs));
    }

    WindowFunctionDefinition(WindowFunctionSupplier functionSupplier, Type type, List<Integer> argumentChannels) {
        this.functionSupplier = functionSupplier;
        this.type = type;
        this.argumentChannels = argumentChannels;
    }

    public Type getType() {
        return this.type;
    }

    public WindowFunction createWindowFunction() {
        return this.functionSupplier.createWindowFunction(this.argumentChannels);
    }
}

