/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;

public class InMemoryExchangeSinkOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final InMemoryExchange inMemoryExchange;
    private boolean finished;

    InMemoryExchangeSinkOperator(OperatorContext operatorContext, InMemoryExchange inMemoryExchange) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.inMemoryExchange = Objects.requireNonNull(inMemoryExchange, "inMemoryExchange is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.inMemoryExchange.getTypes();
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.finished = true;
            this.inMemoryExchange.sinkFinished();
        }
    }

    @Override
    public boolean isFinished() {
        if (!this.finished) {
            this.finished = this.inMemoryExchange.isFinishing();
        }
        return this.finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.inMemoryExchange.waitForWriting();
        if (blocked.isDone()) {
            return NOT_BLOCKED;
        }
        return blocked;
    }

    @Override
    public boolean needsInput() {
        return !this.isFinished() && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Already finished");
        this.inMemoryExchange.addPage(page);
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() throws Exception {
        this.finish();
    }
}

